/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.util;

import fun.fengwk.chatjava.core.client.ChatCompletionsResponse;
import fun.fengwk.chatjava.core.client.request.ChatMessage;
import fun.fengwk.chatjava.core.client.request.ChatRequest;
import fun.fengwk.chatjava.core.client.request.ChatStreamOptions;
import fun.fengwk.chatjava.core.client.request.ChatTool;
import fun.fengwk.chatjava.core.client.response.ChatChoice;
import fun.fengwk.chatjava.core.client.response.ChatResponse;
import fun.fengwk.chatjava.core.client.response.ChatToolCall;
import fun.fengwk.chatjava.core.client.util.ChatMiscUtils;
import java.util.List;

public class ChatUtils {
    private static final String TOOL_CALLS = "tool_calls";
    private static final String FUNCTION = "function";

    private ChatUtils() {
    }

    public static void streamIncludeUsage(ChatRequest chatRequest) {
        ChatStreamOptions streamOptions = new ChatStreamOptions();
        streamOptions.setInclude_usage(true);
        chatRequest.setStream_options(streamOptions);
    }

    public static ChatMessage getMessage(ChatResponse chatResponse) {
        if (chatResponse == null || ChatMiscUtils.isEmpty(chatResponse.getChoices()) || chatResponse.getChoices().get(0) == null) {
            return null;
        }
        ChatChoice chatChoice = chatResponse.getChoices().get(0);
        if (chatChoice.getMessage() != null) {
            return chatChoice.getMessage();
        }
        return chatChoice.getDelta();
    }

    public static String getContent(ChatResponse chatResponse) {
        if (chatResponse == null || ChatMiscUtils.isEmpty(chatResponse.getChoices()) || chatResponse.getChoices().get(0) == null) {
            return "";
        }
        ChatChoice chatChoice = chatResponse.getChoices().get(0);
        if (chatChoice.getMessage() != null) {
            return ChatMiscUtils.nullSafe(chatChoice.getMessage().getContent());
        }
        if (chatChoice.getDelta() != null) {
            return ChatMiscUtils.nullSafe(chatChoice.getDelta().getContent());
        }
        return "";
    }

    public static boolean isFunctionCall(ChatToolCall call) {
        return call != null && FUNCTION.equals(call.getType());
    }

    public static void setFunctionTool(ChatTool tool) {
        if (tool != null) {
            tool.setType(FUNCTION);
        }
    }

    public static boolean isEmptyDelta(ChatCompletionsResponse response) {
        if (!response.isSuccess()) {
            return false;
        }
        List<ChatChoice> choices = response.getChatResponse().getChoices();
        if (ChatMiscUtils.isEmpty(choices)) {
            return false;
        }
        ChatMessage delta = choices.get(0).getDelta();
        return delta != null && ChatMiscUtils.isEmpty(delta.getContent()) && ChatMiscUtils.isEmpty(delta.getTool_calls());
    }

    public static boolean isToolCalls(ChatCompletionsResponse response) {
        if (!response.isSuccess()) {
            return false;
        }
        List<ChatChoice> choices = response.getChatResponse().getChoices();
        if (ChatMiscUtils.isEmpty(choices)) {
            return false;
        }
        if (TOOL_CALLS.equals(choices.get(0).getFinish_reason())) {
            return true;
        }
        ChatMessage delta = choices.get(0).getDelta();
        return delta != null && !ChatMiscUtils.isEmpty(delta.getTool_calls());
    }
}

