/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.util.httpclient;

import fun.fengwk.chatjava.core.client.util.ChatMiscUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatHttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ChatHttpClientUtils.class);

    private ChatHttpClientUtils() {
    }

    public static boolean success(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseBodyString(HttpResponse<InputStream> httpResponse) throws IOException {
        HttpHeaders headers = httpResponse.headers();
        try (InputStream input = httpResponse.body();){
            if (ChatHttpClientUtils.gzip(headers)) {
                input = new GZIPInputStream(input);
            }
            String string = ChatMiscUtils.toString(input, ChatHttpClientUtils.charset(headers));
            return string;
        }
    }

    private static boolean gzip(HttpHeaders headers) {
        for (String contentEncoding : headers.allValues("Content-Encoding")) {
            if (contentEncoding == null || !contentEncoding.contains("gzip")) continue;
            return true;
        }
        return false;
    }

    private static Charset charset(HttpHeaders headers) {
        for (String contentType : headers.allValues("Content-Type")) {
            Charset charset = null;
            try {
                charset = ChatHttpClientUtils.parseContentTypeCharset(contentType);
            }
            catch (UnsupportedCharsetException ignore) {
                log.warn("not support charset, contentType: {}", (Object)contentType);
            }
            if (charset == null) continue;
            return charset;
        }
        return StandardCharsets.UTF_8;
    }

    private static Charset parseContentTypeCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        int i = contentType.indexOf(";");
        if (i == -1) {
            return null;
        }
        String charset = contentType.substring(i + 1);
        if ((charset = charset.replaceAll(" ", "")).startsWith("charset=")) {
            charset = charset.substring("charset=".length());
        }
        return Charset.forName(charset);
    }
}

