/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.util.httpclient;

import fun.fengwk.chatjava.core.client.util.httpclient.ListableProxies;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySelectorAdapter
extends ProxySelector {
    private static final Logger log = LoggerFactory.getLogger(ProxySelectorAdapter.class);
    private final ListableProxies listableProxies;

    public ProxySelectorAdapter(ListableProxies listableProxies) {
        this.listableProxies = Objects.requireNonNull(listableProxies);
    }

    @Override
    public List<Proxy> select(URI uri) {
        block4: {
            List<Proxy> proxies = this.listableProxies.listProxies();
            if (proxies.isEmpty()) break block4;
            String scheme = uri.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme) || "ftp".equals(scheme) || "ftps".equals(scheme)) {
                for (Proxy proxy : proxies) {
                    if (proxy.type() != Proxy.Type.HTTP) continue;
                    return Collections.singletonList(proxy);
                }
            } else {
                for (Proxy proxy : proxies) {
                    if (proxy.type() != Proxy.Type.SOCKS) continue;
                    return Collections.singletonList(proxy);
                }
            }
        }
        return Collections.singletonList(Proxy.NO_PROXY);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        log.error("Failed to connect to '{}'", (Object)uri, (Object)ioe);
    }
}

