/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.util.json;

import fun.fengwk.chatjava.core.client.util.json.ChatJsonAdapter;
import fun.fengwk.chatjava.core.client.util.json.ChatJsonAdapterProvider;
import fun.fengwk.chatjava.core.client.util.json.FastJsonChatJsonAdapter;
import fun.fengwk.chatjava.core.client.util.json.GsonJsonChatJsonAdapter;
import fun.fengwk.chatjava.core.client.util.json.JacksonChatJsonAdapter;
import java.lang.reflect.Type;
import java.util.ServiceLoader;

public class ChatJsonUtils {
    private static volatile ChatJsonAdapter INSTANCE;

    private ChatJsonUtils() {
    }

    private static void autoRegister() {
        ServiceLoader<ChatJsonAdapterProvider> sl = ServiceLoader.load(ChatJsonAdapterProvider.class);
        for (ChatJsonAdapterProvider provider : sl) {
            ChatJsonAdapter chatJsonAdapter = provider.getChatJsonAdapter();
            if (chatJsonAdapter == null) continue;
            ChatJsonUtils.register(chatJsonAdapter);
            return;
        }
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            ChatJsonUtils.register(new JacksonChatJsonAdapter());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("com.google.gson.Gson");
                ChatJsonUtils.register(new GsonJsonChatJsonAdapter());
                return;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class.forName("com.alibaba.fastjson2.JSON");
                    ChatJsonUtils.register(new FastJsonChatJsonAdapter());
                    return;
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    throw new ExceptionInInitializerError("can not found json dependency");
                }
            }
        }
    }

    public static void register(ChatJsonAdapter jsonAdapter) {
        INSTANCE = jsonAdapter;
    }

    public static String toJson(Object obj) {
        return INSTANCE.toJson(obj);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return INSTANCE.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type type) {
        return INSTANCE.fromJson(json, type);
    }

    static {
        ChatJsonUtils.autoRegister();
    }
}

