/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.util.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import fun.fengwk.chatjava.core.client.util.json.ChatJsonAdapter;
import fun.fengwk.chatjava.core.client.util.json.TypeReferenceWrapper;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonChatJsonAdapter
implements ChatJsonAdapter {
    private static final Logger log = LoggerFactory.getLogger(JacksonChatJsonAdapter.class);
    private final ObjectMapper objectMapper;

    public JacksonChatJsonAdapter() {
        this(JacksonChatJsonAdapter.buildDefault());
    }

    public JacksonChatJsonAdapter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private static ObjectMapper buildDefault() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    @Override
    public String toJson(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (Exception ex) {
            log.error("writeValueAsString error", (Throwable)ex);
            return null;
        }
    }

    @Override
    public <T> T fromJson(String json, Class<T> classOfT) {
        if (json == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, classOfT);
        }
        catch (Exception ex) {
            log.error("fromJson error", (Throwable)ex);
            return null;
        }
    }

    @Override
    public <T> T fromJson(String json, Type typeOfT) {
        if (json == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, new TypeReferenceWrapper(typeOfT));
        }
        catch (Exception ex) {
            log.error("fromJson error", (Throwable)ex);
            return null;
        }
    }
}

