/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.util.relfect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public final class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Type rawType;

    public ParameterizedTypeImpl(Type[] actualTypeArguments, Type ownerType, Type rawType) {
        this.actualTypeArguments = actualTypeArguments;
        this.ownerType = ownerType;
        this.rawType = rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
        return Arrays.equals(this.actualTypeArguments, that.actualTypeArguments) && Objects.equals(this.ownerType, that.ownerType) && Objects.equals(this.rawType, that.rawType);
    }

    public int hashCode() {
        int result = this.actualTypeArguments != null ? Arrays.hashCode(this.actualTypeArguments) : 0;
        result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
        result = 31 * result + (this.rawType != null ? this.rawType.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.ownerType != null) {
            builder.append(this.typeName(this.ownerType)).append('.');
        }
        return builder.append(this.typeName(this.rawType)).append('<').append(this.joinActualTypeArguments()).append('>').toString();
    }

    private String joinActualTypeArguments() {
        if (this.actualTypeArguments == null || this.actualTypeArguments.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.actualTypeArguments.length; ++i) {
            builder.append(this.typeName(this.actualTypeArguments[i]));
            if (i >= this.actualTypeArguments.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private String typeName(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }
}

