/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.util.relfect;

import fun.fengwk.chatjava.core.client.util.relfect.GenericArrayTypeImpl;
import fun.fengwk.chatjava.core.client.util.relfect.ParameterizedTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

public class TypeResolver {
    private final Type type;
    private final Class<?> resolvedClass;

    public TypeResolver(Type type) {
        this.type = type;
        this.resolvedClass = this.resolveClass(type);
    }

    private TypeResolver(Type type, Class<?> resolvedClass) {
        this.type = type;
        this.resolvedClass = resolvedClass;
    }

    public boolean isClass() {
        return this.type instanceof Class;
    }

    public boolean isParameterizedType() {
        return this.type instanceof ParameterizedType;
    }

    public boolean isGenericArrayType() {
        return this.type instanceof GenericArrayType;
    }

    public boolean isTypeVariable() {
        return this.type instanceof TypeVariable;
    }

    public boolean isWildcardType() {
        return this.type instanceof WildcardType;
    }

    public <T> Class<T> asClass() {
        if (!this.isClass()) {
            throw new IllegalStateException("Type is not a Class");
        }
        return (Class)this.type;
    }

    public ParameterizedType asParameterizedType() {
        if (!this.isParameterizedType()) {
            throw new IllegalStateException("Type is not a ParameterizedType");
        }
        return (ParameterizedType)this.type;
    }

    public GenericArrayType asGenericArrayType() {
        if (!this.isGenericArrayType()) {
            throw new IllegalStateException("Type is not a GenericArrayType");
        }
        return (GenericArrayType)this.type;
    }

    public <D extends GenericDeclaration> TypeVariable<D> asTypeVariable() {
        if (!this.isTypeVariable()) {
            throw new IllegalStateException("Type is not a TypeVariable");
        }
        return (TypeVariable)this.type;
    }

    public WildcardType asWildcardType() {
        if (!this.isWildcardType()) {
            throw new IllegalStateException("Type is not a WildcardType");
        }
        return (WildcardType)this.type;
    }

    public TypeResolver as(Class<?> target) {
        LinkedList path = new LinkedList();
        if (!this.doFindPath(target, this.resolvedClass, path)) {
            throw new IllegalArgumentException(String.format("%s is not the ancestor of %s", target.getSimpleName(), this.resolvedClass.getSimpleName()));
        }
        TypeResolver tr = this;
        path.pop();
        while (!path.isEmpty()) {
            tr = tr.up(path.pop());
        }
        return tr;
    }

    private Class<?> resolveClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Class<?> componentClass = this.resolveClass(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(componentClass, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            Type bound = this.resolveBounds(((TypeVariable)type).getBounds());
            return bound == null ? Object.class : this.resolveClass(bound);
        }
        if (type instanceof WildcardType) {
            Type upperBound = this.resolveBounds(((WildcardType)type).getUpperBounds());
            if (upperBound != null) {
                return this.resolveClass(upperBound);
            }
            Type lowerBound = this.resolveBounds(((WildcardType)type).getLowerBounds());
            return lowerBound == null ? Object.class : this.resolveClass(lowerBound);
        }
        throw new IllegalStateException(String.format("Unsupported type '%s'", type));
    }

    private Type resolveBounds(Type[] bounds) {
        if (bounds.length == 0 || bounds[0] == Object.class) {
            return null;
        }
        return bounds[0];
    }

    private boolean doFindPath(Class<?> target, Class<?> current, LinkedList<Class<?>> path) {
        Class supClass;
        if (current.equals(target)) {
            path.push(current);
            return true;
        }
        Type supType = current.getGenericSuperclass();
        if (supType != null && this.doFindPath(target, supClass = (Class)(supType instanceof ParameterizedType ? ((ParameterizedType)supType).getRawType() : supType), path)) {
            path.push(current);
            return true;
        }
        Type[] interfaces = current.getGenericInterfaces();
        if (interfaces != null) {
            for (Type inter : interfaces) {
                Class interClass = (Class)(inter instanceof ParameterizedType ? ((ParameterizedType)inter).getRawType() : inter);
                if (!this.doFindPath(target, interClass, path)) continue;
                path.push(current);
                return true;
            }
        }
        return false;
    }

    private TypeResolver up(Class<?> targetClass) {
        Class<?> supClass;
        Map<TypeVariable<?>, Type> typeVarMap = this.getTypeVarMap(this.resolvedClass, this.type);
        Type supType = this.resolvedClass.getGenericSuperclass();
        if (supType != null && this.resolveClass(supType) == targetClass && (supClass = this.resolveClass(supType)) == targetClass) {
            return new TypeResolver(this.resolveType(supType, typeVarMap), supClass);
        }
        Type[] interfaces = this.resolvedClass.getGenericInterfaces();
        if (interfaces != null) {
            for (Type interType : interfaces) {
                Class<?> interClass = this.resolveClass(interType);
                if (interClass != targetClass) continue;
                return new TypeResolver(this.resolveType(interType, typeVarMap), interClass);
            }
        }
        throw new AssertionError((Object)String.format("%s is not %s's parent class or interface", targetClass.getSimpleName(), this.resolvedClass.getSimpleName()));
    }

    private Map<TypeVariable<?>, Type> getTypeVarMap(Class<?> clazz, Type type) {
        if (!(type instanceof ParameterizedType)) {
            return Collections.emptyMap();
        }
        TypeVariable<Class<?>>[] typeVars = clazz.getTypeParameters();
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        assert (typeVars.length == actualTypeArguments.length);
        HashMap typeVarMap = new HashMap();
        for (int i = 0; i < typeVars.length; ++i) {
            typeVarMap.put(typeVars[i], actualTypeArguments[i]);
        }
        return typeVarMap;
    }

    private Type resolveType(Type type, Map<TypeVariable<?>, Type> typeVarMap) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            Type typeVar = typeVarMap.get(type);
            assert (typeVar != null);
            return typeVar;
        }
        if (type instanceof WildcardType) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Object[] oldTypes = parameterizedType.getActualTypeArguments();
            Object[] newTypes = new Type[oldTypes.length];
            for (int i = 0; i < oldTypes.length; ++i) {
                newTypes[i] = this.resolveType((Type)oldTypes[i], typeVarMap);
            }
            if (Arrays.equals(oldTypes, newTypes)) {
                return type;
            }
            return new ParameterizedTypeImpl((Type[])newTypes, parameterizedType.getOwnerType(), parameterizedType.getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type newComponentType;
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type oldComponentType = genericArrayType.getGenericComponentType();
            if (Objects.equals(oldComponentType, newComponentType = this.resolveType(oldComponentType, typeVarMap))) {
                return type;
            }
            return new GenericArrayTypeImpl(newComponentType);
        }
        throw new IllegalStateException(String.format("Unsupported type %s", type.getTypeName()));
    }
}

