/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;

public class EnvConfigurationWithSynonyms
extends AbstractConfiguration {
    protected void addPropertyDirect(String key, Object value) {
        throw new IllegalArgumentException("Environment is read-only. Can't add a new property.");
    }

    private static List<String> synonyms(String key) {
        String dotToUnderscore = key.replace(".", "_").replace("-", "_");
        String upperCase = dotToUnderscore.toUpperCase();
        return List.of(key, dotToUnderscore, upperCase);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    public Object getProperty(String key) {
        for (String s : EnvConfigurationWithSynonyms.synonyms(key)) {
            String result = System.getenv(s);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Iterator<String> getKeys() {
        return System.getenv().keySet().iterator();
    }
}

