/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.text.StrLookup;

public class EnvLookup
extends StrLookup {
    public String lookup(String key) {
        for (String s : this.synonyms(key)) {
            if (s == null) continue;
            return s;
        }
        return "";
    }

    private List<String> synonyms(String key) {
        String dotToUnderscore = key.replace(".", "_").replace("-", "_");
        String upperCase = dotToUnderscore.toUpperCase();
        return Stream.of(System.getenv(dotToUnderscore), System.getenv(upperCase)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

