/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config.options;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractOptions {
    public AbstractOptions() {
    }

    public AbstractOptions(Map<String, String> options) {
        this.parse(options);
    }

    protected abstract void parse(Map<String, String> var1);

    protected static String getVar(Map<String, String> optionsMap, String varName) {
        if (optionsMap.get(varName) == null || optionsMap.get(varName).isEmpty()) {
            return null;
        }
        return optionsMap.get(varName);
    }

    protected static String[] split(String str, char splitter) {
        if (str == null) {
            return null;
        }
        String[] splitStr = StringUtils.split((String)str, (char)splitter);
        String[] out = new String[splitStr.length];
        for (int i = 0; i < splitStr.length; ++i) {
            out[i] = StringUtils.trim((String)splitStr[i]);
        }
        return out;
    }

    protected static int parseInt(Map<String, String> optionsMap, String key, int defaultValue) {
        if (optionsMap.containsKey(key)) {
            return Integer.parseInt(optionsMap.get(key));
        }
        return defaultValue;
    }

    protected static boolean parseBool(Map<String, String> optionsMap, String key) {
        return AbstractOptions.parseBool(optionsMap, key, false);
    }

    protected static boolean parseBool(Map<String, String> optionsMap, String key, boolean defaultValue) {
        String value = optionsMap.get(key);
        if (value == null) {
            return defaultValue;
        }
        return BooleanUtils.toBoolean((String)value);
    }

    public static Map<String, String> getSubmap(Map<String, String> mapIn, String subkey) {
        if (mapIn == null || mapIn.isEmpty()) {
            return Collections.emptyMap();
        }
        return mapIn.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().startsWith(subkey.toLowerCase())).map(entry -> {
            String newKey = ((String)entry.getKey()).substring(subkey.length(), ((String)entry.getKey()).length());
            return new AbstractMap.SimpleImmutableEntry<String, String>(newKey, (String)entry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

