/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config.options;

import io.apiman.common.config.options.AbstractOptions;
import io.apiman.common.config.options.exceptions.InvalidOptionConfigurationException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class GenericOptionsParser
extends AbstractOptions {
    protected TreeMap<String, String> options;

    public GenericOptionsParser(Map<String, String> options) {
        super(options);
    }

    @Override
    protected void parse(Map<String, String> options) {
        this.options = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.options.putAll(options);
    }

    protected TreeMap<String, String> getOptions() {
        return this.options;
    }

    public boolean getBool(List<String> keyAliases, Boolean defaultValue) {
        AliasValueEntry candidate = this.getValue(keyAliases);
        if (candidate == null || StringUtils.isBlank((CharSequence)candidate.value)) {
            return defaultValue;
        }
        Boolean parsed = BooleanUtils.toBooleanObject((String)candidate.value);
        if (parsed == null) {
            throw InvalidOptionConfigurationException.parseFailure(candidate.alias, "boolean", candidate.value);
        }
        return parsed;
    }

    public int getInt(List<String> keyAliases, int defaultValue, Predicate<Integer> constraint, String message) {
        AliasValueEntry candidate = this.getValue(keyAliases);
        if (candidate == null || StringUtils.isBlank((CharSequence)candidate.value)) {
            return defaultValue;
        }
        try {
            int parsedInt = Integer.parseInt(candidate.value);
            if (!constraint.test(parsedInt)) {
                throw InvalidOptionConfigurationException.constraintFailure(candidate.alias, "integer", candidate.value, message);
            }
            return parsedInt;
        }
        catch (NumberFormatException nfe) {
            throw InvalidOptionConfigurationException.parseFailure(candidate.alias, "integer", candidate.value, nfe);
        }
    }

    public long getLong(List<String> keyAliases, long defaultValue, Predicate<Long> constraint, String message) {
        AliasValueEntry candidate = this.getValue(keyAliases);
        if (candidate == null || StringUtils.isBlank((CharSequence)candidate.value)) {
            return defaultValue;
        }
        try {
            long parsedInt = Long.parseLong(candidate.value);
            if (!constraint.test(parsedInt)) {
                throw InvalidOptionConfigurationException.constraintFailure(candidate.alias, "long", candidate.value, message);
            }
            return parsedInt;
        }
        catch (NumberFormatException nfe) {
            throw InvalidOptionConfigurationException.parseFailure(candidate.alias, "long", candidate.value, nfe);
        }
    }

    public String getRequiredString(List<String> keyAliases, Predicate<String> constraint, String message) {
        return Optional.ofNullable(this.getString(keyAliases, null, constraint, message)).orElseThrow(() -> InvalidOptionConfigurationException.requiredValue(keyAliases, "string"));
    }

    public String getString(List<String> keyAliases, String defaultValue, Predicate<String> constraint, String message) {
        AliasValueEntry candidate = this.getValue(keyAliases);
        if (candidate == null || StringUtils.isBlank((CharSequence)candidate.value)) {
            return defaultValue;
        }
        if (!constraint.test(candidate.value)) {
            throw InvalidOptionConfigurationException.constraintFailure(candidate.alias, "string", candidate.value, message);
        }
        return candidate.value;
    }

    public <E extends Enum<E>> E getRequiredEnum(List<String> keyAliases, Class<E> klazz, Function<String, E> converter) {
        return (E)((Enum)Optional.ofNullable(this.getEnum(keyAliases, null, klazz, converter)).orElseThrow(() -> InvalidOptionConfigurationException.requiredValue(keyAliases, "enum")));
    }

    public <E extends Enum<E>> E getEnum(List<String> keyAliases, E defaultValue, Function<String, E> converter) {
        return this.getEnum(keyAliases, defaultValue, defaultValue.getDeclaringClass(), converter);
    }

    private <E extends Enum<E>> E getEnum(List<String> keyAliases, E defaultValue, Class<E> klazz, Function<String, E> converter) {
        AliasValueEntry candidate = this.getValue(keyAliases);
        if (candidate == null || StringUtils.isBlank((CharSequence)candidate.value)) {
            return defaultValue;
        }
        boolean notRecognised = false;
        Enum convertedEnum = null;
        try {
            convertedEnum = (Enum)converter.apply(candidate.value);
        }
        catch (IllegalArgumentException iae) {
            notRecognised = true;
        }
        if (notRecognised || convertedEnum == null) {
            throw InvalidOptionConfigurationException.constraintFailure(candidate.alias, "enum", candidate.value, "Valid inputs are: " + Arrays.toString(klazz.getEnumConstants()));
        }
        return (E)convertedEnum;
    }

    public Path getRequiredPath(List<String> keyAliases, Predicate<Path> constraint, String message) {
        return Optional.ofNullable(this.getPath(keyAliases, null, constraint, message)).orElseThrow(() -> InvalidOptionConfigurationException.requiredValue(keyAliases, "path"));
    }

    public Path getPath(List<String> keyAliases, Path defaultValue, Predicate<Path> constraint, String message) {
        AliasValueEntry candidate = this.getValue(keyAliases);
        if (candidate == null || StringUtils.isBlank((CharSequence)candidate.value)) {
            return defaultValue;
        }
        Path parsedPath = Paths.get(candidate.value, new String[0]);
        if (!constraint.test(parsedPath)) {
            throw InvalidOptionConfigurationException.constraintFailure(candidate.alias, "path", candidate.value, message);
        }
        return parsedPath;
    }

    public URI getRequiredUri(List<String> keyAliases, Predicate<URI> constraint, String message) {
        return Optional.ofNullable(this.getUri(keyAliases, null, constraint, message)).orElseThrow(() -> InvalidOptionConfigurationException.requiredValue(keyAliases, "URI"));
    }

    public URI getUri(List<String> keyAliases, URI defaultValue, Predicate<URI> constraint, String message) {
        URI parsedUri;
        AliasValueEntry candidate = this.getValue(keyAliases);
        if (candidate == null || StringUtils.isBlank((CharSequence)candidate.value)) {
            return defaultValue;
        }
        try {
            parsedUri = URI.create(candidate.value);
        }
        catch (IllegalArgumentException iae) {
            throw InvalidOptionConfigurationException.parseFailure(candidate.alias, "URI", candidate.value, iae);
        }
        if (!constraint.test(parsedUri)) {
            throw InvalidOptionConfigurationException.constraintFailure(candidate.alias, "URI", candidate.value, message);
        }
        return parsedUri;
    }

    @SafeVarargs
    public static <T> List<T> keys(T ... keys) {
        return Arrays.asList(keys);
    }

    private AliasValueEntry getValue(List<String> keyAliases) {
        return keyAliases.stream().filter(candidate -> this.options.containsKey(candidate)).map(candidate -> AliasValueEntry.of(candidate, StringUtils.strip((String)this.options.get(candidate)))).findFirst().orElse(null);
    }

    private static final class AliasValueEntry {
        private final String alias;
        private final String value;

        AliasValueEntry(String alias, String value) {
            this.alias = alias;
            this.value = value;
        }

        static AliasValueEntry of(String alias, String value) {
            return new AliasValueEntry(alias, value);
        }
    }
}

