/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config.options;

import io.apiman.common.config.options.AbstractOptions;
import java.util.Map;

public class HttpConnectorOptions
extends AbstractOptions {
    private static final int DEFAULT_READ_TIMEOUT = 15;
    private static final int DEFAULT_WRITE_TIMEOUT = 15;
    private static final int DEFAULT_CONNECT_TIMEOUT = 10;
    private static final boolean DEFAULT_FOLLOW_REDIRECTS = false;
    private int readTimeout;
    private int writeTimeout;
    private int connectTimeout;
    private boolean followRedirects;

    public HttpConnectorOptions(Map<String, String> options) {
        super(options);
    }

    @Override
    protected void parse(Map<String, String> options) {
        String read = options.get("http.timeouts.read");
        String write = options.get("http.timeouts.write");
        String connect = options.get("http.timeouts.connect");
        String redirects = options.get("http.followRedirects");
        if (read != null) {
            this.setReadTimeout(Integer.parseInt(read));
        } else {
            this.setReadTimeout(15);
        }
        if (write != null) {
            this.setWriteTimeout(Integer.parseInt(write));
        } else {
            this.setWriteTimeout(15);
        }
        if (connect != null) {
            this.setConnectTimeout(Integer.parseInt(connect));
        } else {
            this.setConnectTimeout(10);
        }
        if (redirects != null) {
            this.setFollowRedirects(Boolean.parseBoolean(redirects));
        } else {
            this.setFollowRedirects(false);
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }
}

