/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config.options;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class Predicates {
    public static <T> Predicate<T> anyOk() {
        return any -> true;
    }

    public static String noWhitespaceMsg() {
        return "must not contain any whitespace";
    }

    public static Predicate<String> noWhitespace() {
        return s -> !StringUtils.containsWhitespace((CharSequence)s);
    }

    public static String matchesAnyMsg(String ... allowedValues) {
        return "must be one of: " + String.join((CharSequence)", ", allowedValues);
    }

    public static Predicate<String> matchesAny(String ... allowedValues) {
        return input -> Arrays.stream(allowedValues).map(StringUtils::strip).anyMatch(allowed -> allowed.equalsIgnoreCase((String)input));
    }

    public static String greaterThanZeroMsg() {
        return "must be greater than zero";
    }

    public static Predicate<Long> greaterThanZeroLong() {
        return input -> input > 0L;
    }

    public static Predicate<Integer> greaterThanZeroInt() {
        return input -> input > 0;
    }

    public static String fileExistsMsg(String description) {
        return description + " file was not found";
    }

    public static Predicate<Path> fileExists() {
        return x$0 -> Files.exists(x$0, new LinkOption[0]);
    }

    public static String fileEmptyMsg() {
        return "file must not be empty";
    }

    public static Predicate<Path> fileSizeGreaterThanZero() {
        return f -> {
            try {
                return Files.size(f) > 0L;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        };
    }

    public static Predicate<URI> isHttpOrHttps() {
        return uri -> "http".equalsIgnoreCase(uri.getScheme()) || "https".equalsIgnoreCase(uri.getScheme());
    }

    public static Predicate<Integer> intPercentage() {
        return integer -> integer >= 0 && integer <= 100;
    }

    public static String intPercentageMsg() {
        return "percentage must be an integer value from 0 - 100";
    }
}

