/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config.options.exceptions;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InvalidOptionConfigurationException
extends IllegalArgumentException {
    private String expectedType;
    private String optionName;
    private String actualValue;
    private String constraintFailureMessage;

    public InvalidOptionConfigurationException(String message, Throwable cause) {
        super(message, cause);
    }

    public static InvalidOptionConfigurationException parseFailure(String optionName, String expectedType, String actualValue, Throwable cause) {
        String msg = "Expected '" + optionName + "' to be of type " + expectedType + " but provided value '" + actualValue + "' could not be parsed";
        return new InvalidOptionConfigurationException(msg, cause).setOptionName(optionName).setExpectedType(expectedType).setActualValue(actualValue);
    }

    public static InvalidOptionConfigurationException parseFailure(String optionName, String expectedType, String actualValue) {
        String msg = "Expected '" + optionName + "' to be of type " + expectedType + " but provided value '" + actualValue + "' could not be parsed";
        return new InvalidOptionConfigurationException(msg, null).setOptionName(optionName).setExpectedType(expectedType).setActualValue(actualValue);
    }

    public static InvalidOptionConfigurationException constraintFailure(String optionName, String expectedType, String actualValue, String constraintFailureMessage) {
        String msg = "Option '" + optionName + "' of type " + expectedType + " failed a validation check: " + constraintFailureMessage;
        return new InvalidOptionConfigurationException(msg, null).setOptionName(optionName).setExpectedType(expectedType).setActualValue(actualValue).setConstraintFailureMessage(constraintFailureMessage);
    }

    public static InvalidOptionConfigurationException requiredValue(List<String> keyAliases, String expectedType) {
        String optionName = keyAliases.get(0);
        String msg = "A value of type " + expectedType + " must be provided for '" + optionName + "'";
        return new InvalidOptionConfigurationException(msg, null).setOptionName(optionName).setExpectedType(expectedType);
    }

    public Optional<String> getExpectedType() {
        return Optional.of(this.expectedType);
    }

    private InvalidOptionConfigurationException setExpectedType(String expectedType) {
        this.expectedType = expectedType;
        return this;
    }

    public Optional<String> getOptionName() {
        return Optional.ofNullable(this.optionName);
    }

    private InvalidOptionConfigurationException setOptionName(String optionName) {
        this.optionName = optionName;
        return this;
    }

    public Optional<String> getActualValue() {
        return Optional.ofNullable(this.actualValue);
    }

    private InvalidOptionConfigurationException setActualValue(String actualValue) {
        this.actualValue = actualValue;
        return this;
    }

    public Optional<String> getConstraintFailureMessage() {
        return Optional.ofNullable(this.constraintFailureMessage);
    }

    private InvalidOptionConfigurationException setConstraintFailureMessage(String constraintFailureMessage) {
        this.constraintFailureMessage = constraintFailureMessage;
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidOptionConfigurationException that = (InvalidOptionConfigurationException)o;
        return Objects.equals(this.expectedType, that.expectedType) && Objects.equals(this.optionName, that.optionName) && Objects.equals(this.actualValue, that.actualValue) && Objects.equals(this.constraintFailureMessage, that.constraintFailureMessage);
    }

    public int hashCode() {
        return Objects.hash(this.expectedType, this.optionName, this.actualValue, this.constraintFailureMessage);
    }
}

