/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.logging;

import io.apiman.common.logging.ApimanLoggerFactoryRegistry;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.logging.IDelegateFactory;
import io.apiman.common.logging.change.LogFileConfigManager;
import io.apiman.common.logging.change.LoggingChangeRequest;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.collections4.MapUtils;

public class ApimanLoggerFactory {
    public static final String APIMAN_LOGGER = "apiman.logger-delegate";
    private static final LogFileConfigManager LOG_FILE_CONFIG_MANAGER;
    private static volatile boolean LOGGER_RESOLVED;
    private static IDelegateFactory LOGGER_FACTORY;

    public static IApimanLogger getLogger(String name) {
        return ApimanLoggerFactory.getLoggerFactory().createLogger(name);
    }

    public static IApimanLogger getLogger(Class<?> klazz) {
        return ApimanLoggerFactory.getLoggerFactory().createLogger(klazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IDelegateFactory getLoggerFactory() {
        if (LOGGER_RESOLVED) return LOGGER_FACTORY;
        Class<ApimanLoggerFactory> clazz = ApimanLoggerFactory.class;
        synchronized (ApimanLoggerFactory.class) {
            if (LOGGER_RESOLVED) return LOGGER_FACTORY;
            LOGGER_FACTORY = ApimanLoggerFactory.resolveLoggerFactory();
            LOGGER_RESOLVED = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return LOGGER_FACTORY;
        }
    }

    private static IDelegateFactory resolveLoggerFactory() {
        String sysProp = System.getProperty(APIMAN_LOGGER);
        if (sysProp == null) {
            return ApimanLoggerFactoryRegistry.getDefaultLoggerFactory();
        }
        return ApimanLoggerFactoryRegistry.getLoggerFactory(sysProp);
    }

    public static synchronized void setDelegate(IDelegateFactory delegate) {
        LOGGER_FACTORY = delegate;
        LOGGER_RESOLVED = true;
    }

    public static synchronized void overrideLoggerConfig(LoggingChangeRequest newLoggerConfig) {
        try {
            LOG_FILE_CONFIG_MANAGER.write(newLoggerConfig);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private static void setLocally(LoggingChangeRequest changeRequest) {
        IApimanLogger log = ApimanLoggerFactory.getLogger(ApimanLoggerFactory.class);
        IDelegateFactory factory = ApimanLoggerFactory.getLoggerFactory();
        if (changeRequest.getLoggerConfig() != null && changeRequest.getLoggerConfig().length > 0) {
            try {
                File loggerConfigTmp = File.createTempFile("ApimanLoggerConfig", "temp");
                loggerConfigTmp.deleteOnExit();
                Files.write(loggerConfigTmp.toPath(), changeRequest.getLoggerConfig(), new OpenOption[0]).toFile();
                factory.overrideLoggerConfig(loggerConfigTmp);
            }
            catch (IOException ioe) {
                log.error(ioe, "Attempt to load a new logger configuration failed. Was the file in the correct format? Logger configuration will be unchanged. {0}", ioe.getMessage());
            }
        }
        if (MapUtils.isNotEmpty(changeRequest.getLogOverrides())) {
            factory.overrideLoggerConfig(changeRequest.getLogOverrides());
        }
    }

    static {
        LOGGER_RESOLVED = false;
        try {
            LOG_FILE_CONFIG_MANAGER = new LogFileConfigManager(ApimanLoggerFactory::setLocally);
            LOG_FILE_CONFIG_MANAGER.watch();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

