/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.logging;

import io.apiman.common.logging.IDelegateFactory;
import io.apiman.common.logging.annotations.ApimanLoggerFactory;
import io.apiman.common.logging.impl.SoutDelegateFactory;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.HashMap;
import java.util.Map;

public class ApimanLoggerFactoryRegistry {
    private static final Map<String, IDelegateFactory> DELEGATE_FACTORY_MAP = new HashMap<String, IDelegateFactory>();
    private static IDelegateFactory DEFAULT_FACTORY = new SoutDelegateFactory();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void resolveAllImplementations() {
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().enableClassInfo().acceptPackages(new String[]{"io.apiman.common.logging"}).scan();){
            for (ClassInfo loggerFactoryKlazz : scanResult.getClassesWithAnnotation(ApimanLoggerFactory.class)) {
                AnnotationInfo loggerFactoryAnno = loggerFactoryKlazz.getAnnotationInfo(ApimanLoggerFactory.class);
                String name = (String)((AnnotationParameterValue)loggerFactoryAnno.getParameterValues().get(0)).getValue();
                try {
                    DELEGATE_FACTORY_MAP.put(name, (IDelegateFactory)loggerFactoryKlazz.loadClass().newInstance());
                }
                catch (ClassCastException classCastException) {
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
    }

    public static void register(String name, IDelegateFactory loggerFactory) {
        DELEGATE_FACTORY_MAP.put(name, loggerFactory);
    }

    public static void registerAsDefault(String name, IDelegateFactory loggerFactory) {
        DELEGATE_FACTORY_MAP.put(name, loggerFactory);
        DEFAULT_FACTORY = loggerFactory;
    }

    static IDelegateFactory getLoggerFactory(String name) {
        return DELEGATE_FACTORY_MAP.getOrDefault(name, new SoutDelegateFactory());
    }

    static IDelegateFactory getDefaultLoggerFactory() {
        return DEFAULT_FACTORY;
    }

    static {
        ApimanLoggerFactoryRegistry.resolveAllImplementations();
    }
}

