/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.logging.change;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.common.logging.change.LoggingChangeRequest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class LogFileConfigManager {
    private final Path fileToWatch;
    private final WatchService watchService;
    private final Path fileParent;
    private final SimpleChangeRequestHandler changeHandler;
    private final ObjectMapper om = new ObjectMapper();
    private boolean running = true;

    public LogFileConfigManager(SimpleChangeRequestHandler changeHandler) throws IOException {
        this.fileToWatch = Paths.get(System.getProperty("java.io.tmpdir"), "local-deployment-logger-config");
        this.fileParent = this.fileToWatch.getParent();
        this.changeHandler = changeHandler;
        this.watchService = FileSystems.getDefault().newWatchService();
    }

    public void write(LoggingChangeRequest loggingChangeRequest) throws IOException {
        Files.write(this.fileToWatch, this.om.writeValueAsBytes((Object)loggingChangeRequest), new OpenOption[0]);
    }

    public void watch() {
        Runnable runnable = () -> {
            try {
                this.doPollingLoop();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.running = false;
            }
        };
        Thread watchThread = new Thread(runnable);
        watchThread.setDaemon(true);
        watchThread.start();
    }

    private void doPollingLoop() throws IOException, InterruptedException {
        this.fileParent.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
        while (this.running) {
            WatchKey keys = this.watchService.take();
            for (WatchEvent<?> event : keys.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE) || kind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
                    Path changed = this.fileParent.resolve((Path)event.context());
                    if (!changed.getFileName().equals(this.fileToWatch.getFileName()) || !Files.exists(changed, new LinkOption[0]) || Files.size(changed) <= 0L) continue;
                    this.trigger();
                    continue;
                }
                if (kind.equals(StandardWatchEventKinds.OVERFLOW)) {
                    this.trigger();
                    continue;
                }
                if (!kind.equals(StandardWatchEventKinds.ENTRY_DELETE)) continue;
            }
        }
    }

    private void trigger() throws IOException {
        LoggingChangeRequest change = (LoggingChangeRequest)this.om.readValue(this.fileToWatch.toFile(), LoggingChangeRequest.class);
        this.changeHandler.handle(change);
    }

    @FunctionalInterface
    public static interface SimpleChangeRequestHandler {
        public void handle(LoggingChangeRequest var1);
    }
}

