/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.logging.impl;

import io.apiman.common.logging.IApimanLogger;
import java.util.List;
import java.util.function.Consumer;

public class MultiLogger
implements IApimanLogger {
    private final List<IApimanLogger> delegates;

    public MultiLogger(List<IApimanLogger> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void info(String message) {
        this.doLogging(delegateLogger -> delegateLogger.info(message));
    }

    @Override
    public void info(String message, Object ... args) {
        this.doLogging(delegateLogger -> delegateLogger.info(message, args));
    }

    @Override
    public void warn(String message) {
        this.doLogging(delegateLogger -> delegateLogger.warn(message));
    }

    @Override
    public void warn(String message, Object ... args) {
        this.doLogging(delegateLogger -> delegateLogger.warn(message, args));
    }

    @Override
    public void debug(String message) {
        this.doLogging(delegateLogger -> delegateLogger.debug(message));
    }

    @Override
    public void debug(String message, Object ... args) {
        this.doLogging(delegateLogger -> delegateLogger.debug(message, args));
    }

    @Override
    public void trace(String message) {
        this.doLogging(delegateLogger -> delegateLogger.trace(message));
    }

    @Override
    public void trace(String message, Object ... args) {
        this.doLogging(delegateLogger -> delegateLogger.trace(message, args));
    }

    @Override
    public void error(Throwable error) {
        this.doLogging(delegateLogger -> delegateLogger.error(error));
    }

    @Override
    public void error(String message, Throwable error) {
        this.doLogging(delegateLogger -> delegateLogger.error(message, error));
    }

    @Override
    public void error(Throwable error, String message, Object ... args) {
        this.doLogging(delegateLogger -> delegateLogger.error(error, message, args));
    }

    private void doLogging(Consumer<IApimanLogger> consumerFunction) {
        for (IApimanLogger delegate : this.delegates) {
            consumerFunction.accept(delegate);
        }
    }
}

