/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.secvault.ciphertool;

import io.ballerina.messaging.secvault.ciphertool.CipherToolException;
import io.ballerina.messaging.secvault.ciphertool.CipherToolRuntimeException;
import io.ballerina.messaging.secvault.ciphertool.utils.CommandLineParser;
import io.ballerina.messaging.secvault.ciphertool.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherToolInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CipherToolInitializer.class);

    public static void main(String[] args) {
        CipherToolInitializer.execute(args);
    }

    public static void execute(String ... toolArgs) {
        CommandLineParser commandLineParser;
        try {
            commandLineParser = Utils.createCommandLineParser(toolArgs);
        }
        catch (CipherToolException e) {
            CipherToolInitializer.printHelpMessage();
            throw new CipherToolRuntimeException("Unable to run CipherTool", e);
        }
        URLClassLoader urlClassLoader = Utils.getCustomClassLoader(commandLineParser.getCustomLibPath());
        String brokerFilePath = System.getProperty("broker.config");
        String configYamlPath = commandLineParser.getCustomConfigPath().orElse(brokerFilePath);
        String commandName = commandLineParser.getCommandName().orElse("");
        String commandParam = commandLineParser.getCommandParam().orElse("");
        try {
            Path secureVaultConfigPath = Paths.get(configYamlPath, new String[0]);
            Object objCipherTool = Utils.createCipherTool(urlClassLoader, secureVaultConfigPath);
            CipherToolInitializer.processCommand(commandName, commandParam, objCipherTool);
            if (LOGGER.isDebugEnabled()) {
                if (commandLineParser.getCommandName().isPresent()) {
                    LOGGER.debug("Command: " + commandName + " executed successfully with configuration file path: " + secureVaultConfigPath.toString());
                } else {
                    LOGGER.debug("Secrets encrypted successfully with configuration file path: " + secureVaultConfigPath.toString());
                }
            }
        }
        catch (CipherToolException e) {
            throw new CipherToolRuntimeException("Unable to run CipherTool", e);
        }
    }

    private static void processCommand(String command, String parameter, Object objCipherTool) throws CipherToolException {
        try {
            switch (command) {
                case "-encryptText": {
                    Method method = objCipherTool.getClass().getMethod("encryptText", String.class);
                    method.invoke(objCipherTool, parameter);
                    break;
                }
                case "-decryptText": {
                    Method method = objCipherTool.getClass().getMethod("decryptText", String.class);
                    method.invoke(objCipherTool, parameter);
                    break;
                }
                default: {
                    Method method = objCipherTool.getClass().getMethod("encryptSecrets", new Class[0]);
                    method.invoke(objCipherTool, new Object[0]);
                    break;
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CipherToolException("Failed to execute Cipher Tool command", e);
        }
    }

    private static void printHelpMessage() {
        LOGGER.info("\nIncorrect usage of the cipher tool.\n\nInstructions: sh ciphertool.sh [<command> <parameter>]\n\n-- command      -configPath | -encryptText | -decryptText | -customLibPath\n-- parameter    input to the command\n\nUsages:\n\n* Load default secure vault config from [MESSAGE_BROKER_HOME]/conf/broker.yaml and encrypts the secrets specified in the [MESSAGE_BROKER_HOME]/conf/security/secrets.properties file. \n     Eg: ciphertool.sh\n\n* Load secure vault config from given config path and encrypt secrets in the specified secrets.properties file.\n     Eg: ciphertool.sh -configPath /home/user/custom/config/secure-vault.yaml\n\n* Load libraries in the given path first and perform the same operation as above.\n     Eg: ciphertool.sh -configPath /home/user/custom/config/secure-vault.yaml -customLibPath /home/user/custom/libs\n\n* -encryptText : this option will first encrypt a given text and then prints the base64 encoded\n   string of the encoded cipher text in the console.\n     Eg: ciphertool.sh -encryptText Ballerina@WSO2\n\n* -decryptText : this option accepts base64 encoded cipher text and prints the decoded plain text in the console.\n     Eg: ciphertool.sh -decryptText XxXxXx\n");
    }
}

