/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.secvault.ciphertool;

import java.io.PrintStream;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.wso2.carbon.secvault.MasterKeyReader;
import org.wso2.carbon.secvault.SecretRepository;
import org.wso2.carbon.secvault.SecureVaultUtils;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.wso2.carbon.secvault.model.SecureVaultConfiguration;

public class CipherTool {
    private static final PrintStream out = System.out;
    private SecureVaultConfiguration secureVaultConfiguration;
    private SecretRepository secretRepository;

    public void init(URLClassLoader urlClassLoader, Path secureVaultConfigPath) throws SecureVaultException {
        MasterKeyReader masterKeyReader;
        this.secureVaultConfiguration = (SecureVaultConfiguration)SecureVaultUtils.getSecureVaultConfig((Path)secureVaultConfigPath).orElseThrow(() -> new SecurityException("Error occurred when obtaining secure vault configuration"));
        String secretRepositoryType = (String)this.secureVaultConfiguration.getSecretRepositoryConfig().getType().orElseThrow(() -> new SecureVaultException("Secret repository type is mandatory"));
        String masterKeyReaderType = (String)this.secureVaultConfiguration.getMasterKeyReaderConfig().getType().orElseThrow(() -> new SecureVaultException("Master key reader type is mandatory"));
        try {
            masterKeyReader = (MasterKeyReader)urlClassLoader.loadClass(masterKeyReaderType).newInstance();
            this.secretRepository = (SecretRepository)urlClassLoader.loadClass(secretRepositoryType).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SecureVaultException("Failed to instantiate implementation classes.", (Throwable)e);
        }
        masterKeyReader.init(this.secureVaultConfiguration.getMasterKeyReaderConfig());
        this.secretRepository.init(this.secureVaultConfiguration.getSecretRepositoryConfig(), masterKeyReader);
    }

    public void encryptSecrets() throws SecureVaultException {
        this.secretRepository.persistSecrets(this.secureVaultConfiguration.getSecretRepositoryConfig());
    }

    public char[] encryptText(String plainText) throws SecureVaultException {
        byte[] encryptedPassword = this.secretRepository.encrypt(SecureVaultUtils.toBytes((String)plainText.trim()));
        char[] base64Encoded = SecureVaultUtils.toChars((byte[])SecureVaultUtils.base64Encode((byte[])encryptedPassword));
        this.printOutput("Encrypted value : " + String.valueOf(base64Encoded));
        return base64Encoded;
    }

    public char[] decryptText(String cipherText) throws SecureVaultException {
        byte[] decryptedPassword = this.secretRepository.decrypt(SecureVaultUtils.base64Decode((byte[])SecureVaultUtils.toBytes((String)cipherText)));
        this.printOutput("Decrypted value : " + String.valueOf(SecureVaultUtils.toChars((byte[])decryptedPassword)));
        return SecureVaultUtils.toChars((byte[])decryptedPassword);
    }

    private void printOutput(String message) {
        out.println(message);
    }
}

