/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.SetVariablesCommandStep1;
import io.camunda.zeebe.client.api.response.SetVariablesResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.response.SetVariablesResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class SetVariablesCommandImpl
implements SetVariablesCommandStep1,
SetVariablesCommandStep1.SetVariablesCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.SetVariablesRequest.Builder builder;
    private final JsonMapper jsonMapper;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public SetVariablesCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long elementInstanceKey, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.jsonMapper = jsonMapper;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.SetVariablesRequest.newBuilder();
        this.builder.setElementInstanceKey(elementInstanceKey);
    }

    @Override
    public FinalCommandStep<SetVariablesResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<SetVariablesResponse> send() {
        GatewayOuterClass.SetVariablesRequest request = this.builder.build();
        RetriableClientFutureImpl<SetVariablesResponse, GatewayOuterClass.SetVariablesResponse> future = new RetriableClientFutureImpl<SetVariablesResponse, GatewayOuterClass.SetVariablesResponse>(SetVariablesResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.SetVariablesResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.SetVariablesResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.SetVariablesRequest request, StreamObserver<GatewayOuterClass.SetVariablesResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).setVariables(request, streamObserver);
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 local(boolean local) {
        this.builder.setLocal(local);
        return this;
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(InputStream variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.validateJson("variables", variables));
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(String variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.validateJson("variables", variables));
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(Map<String, Object> variables) {
        return this.variables((Object)variables);
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(Object variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.toJson(variables));
    }

    private SetVariablesCommandStep1.SetVariablesCommandStep2 setVariables(String jsonDocument) {
        this.builder.setVariables(jsonDocument);
        return this;
    }
}

