/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.oauth;

import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProvider;
import io.camunda.zeebe.client.impl.util.Environment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Objects;

public final class OAuthCredentialsProviderBuilder {
    public static final String INVALID_ARGUMENT_MSG = "Expected valid %s but none was provided.";
    public static final String OAUTH_ENV_CLIENT_ID = "ZEEBE_CLIENT_ID";
    public static final String OAUTH_ENV_CLIENT_SECRET = "ZEEBE_CLIENT_SECRET";
    public static final String OAUTH_ENV_TOKEN_AUDIENCE = "ZEEBE_TOKEN_AUDIENCE";
    public static final String OAUTH_ENV_TOKEN_SCOPE = "ZEEBE_TOKEN_SCOPE";
    public static final String OAUTH_ENV_AUTHORIZATION_SERVER = "ZEEBE_AUTHORIZATION_SERVER_URL";
    public static final String OAUTH_ENV_CACHE_PATH = "ZEEBE_CLIENT_CONFIG_PATH";
    public static final String OAUTH_ENV_CONNECT_TIMEOUT = "ZEEBE_AUTH_CONNECT_TIMEOUT";
    public static final String OAUTH_ENV_READ_TIMEOUT = "ZEEBE_AUTH_READ_TIMEOUT";
    private static final String DEFAULT_AUTHZ_SERVER = "https://login.cloud.camunda.io/oauth/token/";
    private static final Duration DEFAULT_CONNECT_TIMEOUT;
    private static final Duration DEFAULT_READ_TIMEOUT;
    private String clientId;
    private String clientSecret;
    private String audience;
    private String scope;
    private String authorizationServerUrl;
    private URL authorizationServer;
    private String credentialsCachePath;
    private File credentialsCache;
    private Duration connectTimeout;
    private Duration readTimeout;

    public OAuthCredentialsProviderBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    String getClientId() {
        return this.clientId;
    }

    public OAuthCredentialsProviderBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    String getClientSecret() {
        return this.clientSecret;
    }

    public OAuthCredentialsProviderBuilder audience(String audience) {
        this.audience = audience;
        return this;
    }

    String getAudience() {
        return this.audience;
    }

    public OAuthCredentialsProviderBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    String getScope() {
        return this.scope;
    }

    public OAuthCredentialsProviderBuilder authorizationServerUrl(String authorizationServerUrl) {
        this.authorizationServerUrl = authorizationServerUrl;
        return this;
    }

    URL getAuthorizationServer() {
        return this.authorizationServer;
    }

    public OAuthCredentialsProviderBuilder credentialsCachePath(String cachePath) {
        this.credentialsCachePath = cachePath;
        return this;
    }

    File getCredentialsCache() {
        return this.credentialsCache;
    }

    public OAuthCredentialsProviderBuilder connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public OAuthCredentialsProviderBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public OAuthCredentialsProvider build() {
        this.checkEnvironmentOverrides();
        this.applyDefaults();
        this.validate();
        return new OAuthCredentialsProvider(this);
    }

    private void checkEnvironmentOverrides() {
        String envClientId = Environment.system().get(OAUTH_ENV_CLIENT_ID);
        String envClientSecret = Environment.system().get(OAUTH_ENV_CLIENT_SECRET);
        String envAudience = Environment.system().get(OAUTH_ENV_TOKEN_AUDIENCE);
        String envScope = Environment.system().get(OAUTH_ENV_TOKEN_SCOPE);
        String envAuthorizationUrl = Environment.system().get(OAUTH_ENV_AUTHORIZATION_SERVER);
        String envCachePath = Environment.system().get(OAUTH_ENV_CACHE_PATH);
        String envReadTimeout = Environment.system().get(OAUTH_ENV_READ_TIMEOUT);
        String envConnectTimeout = Environment.system().get(OAUTH_ENV_CONNECT_TIMEOUT);
        if (envClientId != null) {
            this.clientId = envClientId;
        }
        if (envClientSecret != null) {
            this.clientSecret = envClientSecret;
        }
        if (envAudience != null) {
            this.audience = envAudience;
        }
        if (envScope != null) {
            this.scope = envScope;
        }
        if (envAuthorizationUrl != null) {
            this.authorizationServerUrl = envAuthorizationUrl;
        }
        if (envCachePath != null) {
            this.credentialsCachePath = envCachePath;
        }
        if (envConnectTimeout != null) {
            this.connectTimeout = Duration.ofMillis(Long.parseLong(envConnectTimeout));
        }
        if (envReadTimeout != null) {
            this.readTimeout = Duration.ofMillis(Long.parseLong(envReadTimeout));
        }
    }

    private void applyDefaults() {
        if (this.credentialsCachePath == null) {
            this.credentialsCachePath = Paths.get(System.getProperty("user.home"), ".camunda", "credentials").toAbsolutePath().toString();
        }
        if (this.authorizationServerUrl == null) {
            this.authorizationServerUrl = DEFAULT_AUTHZ_SERVER;
        }
        if (this.connectTimeout == null) {
            this.connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        }
        if (this.readTimeout == null) {
            this.readTimeout = DEFAULT_READ_TIMEOUT;
        }
    }

    private void validate() {
        try {
            Objects.requireNonNull(this.clientId, String.format(INVALID_ARGUMENT_MSG, "client id"));
            Objects.requireNonNull(this.clientSecret, String.format(INVALID_ARGUMENT_MSG, "client secret"));
            Objects.requireNonNull(this.audience, String.format(INVALID_ARGUMENT_MSG, "audience"));
            Objects.requireNonNull(this.authorizationServerUrl, String.format(INVALID_ARGUMENT_MSG, "authorization server URL"));
            this.authorizationServer = new URL(this.authorizationServerUrl);
            this.credentialsCache = new File(this.credentialsCachePath);
            if (this.credentialsCache.isDirectory()) {
                throw new IllegalArgumentException("Expected specified credentials cache to be a file but found directory instead.");
            }
            this.validateTimeout(this.connectTimeout, "ConnectTimeout");
            this.validateTimeout(this.readTimeout, "ReadTimeout");
        }
        catch (IOException | NullPointerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void validateTimeout(Duration timeout, String timeoutName) {
        if (timeout.isZero() || timeout.isNegative() || timeout.toMillis() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("%s timeout is %s milliseconds, expected timeout to be a positive number of milliseconds smaller than %s.", timeoutName, timeout.toMillis(), Integer.MAX_VALUE));
        }
    }

    static {
        DEFAULT_READ_TIMEOUT = DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    }
}

