/**
 * Copyright 2019 The CloudEvents Authors
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.cloudevents;

import java.util.Map;
import java.util.Optional;

/**
 * An abstract event envelope
 * @param <A> The attributes type
 * @param <T> The 'data' type
 * @author fabiojose
 */
public interface CloudEvent<A extends Attributes, T> {

    /**
     * The event context attributes
     */
    A getAttributes();

    /**
     * The event data
     */
    Optional<T> getData();

    byte[] getDataBase64();

    /**
     * The event extensions
     */
    Map<String, Object> getExtensions();
}
