/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.debezium.config.Configuration;
import io.debezium.converters.CloudEventsConverter;
import io.debezium.data.SchemaUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.Converter;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;

public class CloudEventsConverterTest {
    public static void shouldConvertToCloudEventsInJson(SourceRecord record, boolean hasTransaction) {
        CloudEventsConverterTest.shouldConvertToCloudEventsInJson(record, hasTransaction, valueJson -> {});
    }

    public static void shouldConvertToCloudEventsInJson(SourceRecord record, boolean hasTransaction, Consumer<JsonNode> furtherAssertions) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serializer.type", "json");
        config.put("data.serializer.type", "json");
        config.put("json.schemas.enable", Boolean.TRUE.toString());
        config.put("json.schemas.cache.size", String.valueOf(100));
        CloudEventsConverter cloudEventsConverter = new CloudEventsConverter();
        cloudEventsConverter.configure(config, false);
        JsonNode valueJson = null;
        String msg = null;
        try {
            if (record.key() != null) {
                msg = "checking key is not null";
                Assertions.assertThat((Object)record.key()).isNotNull();
                Assertions.assertThat((Object)record.keySchema()).isNotNull();
            } else {
                msg = "checking key schema and key are both null";
                Assertions.assertThat((Object)record.key()).isNull();
                Assertions.assertThat((Object)record.keySchema()).isNull();
            }
            if (record.value() == null) {
                msg = "checking value schema is null";
                Assertions.assertThat((Object)record.valueSchema()).isNull();
                msg = "checking key is not null when value is null";
                Assertions.assertThat((Object)record.key()).isNotNull();
            } else {
                msg = "checking value schema is not null";
                Assertions.assertThat((Object)record.valueSchema()).isNotNull();
            }
            msg = "converting value using CloudEvents JSON converter";
            byte[] valueBytes = cloudEventsConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using CE deserializer";
            SchemaAndValue ceValue = cloudEventsConverter.toConnectData(record.topic(), valueBytes);
            msg = "deserializing value using JSON deserializer";
            try (JsonDeserializer jsonDeserializer = new JsonDeserializer();){
                jsonDeserializer.configure(Collections.emptyMap(), false);
                valueJson = jsonDeserializer.deserialize(record.topic(), valueBytes);
            }
            msg = "inspecting all required CloudEvents fields in the value";
            Assertions.assertThat((Iterable)valueJson.get("id")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("source")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("specversion")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("dataschema")).isNull();
            Assertions.assertThat((Iterable)valueJson.get("type")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("datacontenttype")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("time")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("data")).isNotNull();
            msg = "inspecting required CloudEvents extension attributes for Debezium";
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumop")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumtsms")).isNotNull();
            if (hasTransaction) {
                msg = "inspecting transaction metadata attributes";
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxid")).isNotNull();
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxtotalorder")).isNotNull();
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxdatacollectionorder")).isNotNull();
            }
            msg = "inspecting the data field in the value";
            JsonNode dataJson = valueJson.get("data");
            Assertions.assertThat((Iterable)dataJson.get("schema")).isNotNull();
            Assertions.assertThat((Iterable)dataJson.get("payload")).isNotNull();
            Assertions.assertThat((Iterable)dataJson.get("payload").get("after")).isNotNull();
            furtherAssertions.accept(valueJson);
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            Testing.print("  value deserialized from CloudEvents in JSON: " + CloudEventsConverterTest.prettyJson(valueJson));
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    public static void shouldConvertToCloudEventsInJsonWithDataAsAvro(SourceRecord record, boolean hasTransaction) {
        CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro(record, "after", hasTransaction);
    }

    public static void shouldConvertToCloudEventsInJsonWithDataAsAvro(SourceRecord record, String fieldName, boolean hasTransaction) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serializer.type", "json");
        config.put("data.serializer.type", "avro");
        config.put("avro.schema.registry.url", "http://fake-url");
        MockSchemaRegistryClient ceSchemaRegistry = new MockSchemaRegistryClient();
        AvroConverter avroConverter = new AvroConverter((SchemaRegistryClient)ceSchemaRegistry);
        avroConverter.configure(Configuration.from(config).subset("avro", true).asMap(), false);
        CloudEventsConverter cloudEventsConverter = new CloudEventsConverter((Converter)avroConverter);
        cloudEventsConverter.configure(config, false);
        JsonNode valueJson = null;
        String msg = null;
        try {
            if (record.key() != null) {
                msg = "checking key is not null";
                Assertions.assertThat((Object)record.key()).isNotNull();
                Assertions.assertThat((Object)record.keySchema()).isNotNull();
            } else {
                msg = "checking key schema and key are both null";
                Assertions.assertThat((Object)record.key()).isNull();
                Assertions.assertThat((Object)record.keySchema()).isNull();
            }
            if (record.value() == null) {
                msg = "checking value schema is null";
                Assertions.assertThat((Object)record.valueSchema()).isNull();
                msg = "checking key is not null when value is null";
                Assertions.assertThat((Object)record.key()).isNotNull();
            } else {
                msg = "checking value schema is not null";
                Assertions.assertThat((Object)record.valueSchema()).isNotNull();
            }
            msg = "converting value using CloudEvents JSON converter";
            byte[] valueBytes = cloudEventsConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using CE deserializer";
            SchemaAndValue ceValue = cloudEventsConverter.toConnectData(record.topic(), valueBytes);
            msg = "deserializing value using JSON deserializer";
            try (JsonDeserializer jsonDeserializer = new JsonDeserializer();){
                jsonDeserializer.configure(Collections.emptyMap(), false);
                valueJson = jsonDeserializer.deserialize(record.topic(), valueBytes);
            }
            msg = "inspecting all required CloudEvents fields in the value";
            Assertions.assertThat((Iterable)valueJson.get("id")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("source")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("specversion")).isNotNull();
            Assertions.assertThat((String)valueJson.get("datacontenttype").asText()).isEqualTo((Object)"application/avro");
            Assertions.assertThat((String)valueJson.get("dataschema").asText()).startsWith((CharSequence)"http://fake-url/schemas/ids/");
            Assertions.assertThat((Iterable)valueJson.get("type")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("time")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("data")).isNotNull();
            msg = "inspecting required CloudEvents extension attributes for Debezium";
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumop")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumtsms")).isNotNull();
            if (hasTransaction) {
                msg = "inspecting transaction metadata attributes";
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxid")).isNotNull();
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxtotalorder")).isNotNull();
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxdatacollectionorder")).isNotNull();
            }
            msg = "inspecting the data field in the value";
            JsonNode dataJson = valueJson.get("data");
            Assertions.assertThat((Iterable)dataJson).isNotNull();
            avroConverter.configure(Collections.singletonMap("schema.registry.url", "http://fake-url"), false);
            SchemaAndValue data = avroConverter.toConnectData(record.topic(), Base64.getDecoder().decode(dataJson.asText()));
            Assertions.assertThat((Object)data.value()).isInstanceOf(Struct.class);
            ((ObjectAssert)Assertions.assertThat((Object)((Struct)data.value()).get(fieldName)).describedAs("Field must be set: " + fieldName, new Object[0])).isNotNull();
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            Testing.print("  value deserialized from CloudEvents in JSON: " + CloudEventsConverterTest.prettyJson(valueJson));
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    public static void shouldConvertToCloudEventsInAvro(SourceRecord record, String connectorName, String serverName, boolean hasTransaction) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serializer.type", "avro");
        config.put("data.serializer.type", "avro");
        config.put("avro.schema.registry.url", "http://fake-url");
        MockSchemaRegistryClient ceSchemaRegistry = new MockSchemaRegistryClient();
        AvroConverter avroConverter = new AvroConverter((SchemaRegistryClient)ceSchemaRegistry);
        avroConverter.configure(Configuration.from(config).subset("avro", true).asMap(), false);
        CloudEventsConverter cloudEventsConverter = new CloudEventsConverter((Converter)avroConverter);
        cloudEventsConverter.configure(config, false);
        SchemaAndValue avroSchemaAndValue = null;
        String msg = null;
        try {
            if (record.key() != null) {
                msg = "checking key is not null";
                Assertions.assertThat((Object)record.key()).isNotNull();
                Assertions.assertThat((Object)record.keySchema()).isNotNull();
            } else {
                msg = "checking key schema and key are both null";
                Assertions.assertThat((Object)record.key()).isNull();
                Assertions.assertThat((Object)record.keySchema()).isNull();
            }
            if (record.value() == null) {
                msg = "checking value schema is null";
                Assertions.assertThat((Object)record.valueSchema()).isNull();
                msg = "checking key is not null when value is null";
                Assertions.assertThat((Object)record.key()).isNotNull();
            } else {
                msg = "checking value schema is not null";
                Assertions.assertThat((Object)record.valueSchema()).isNotNull();
            }
            msg = "converting value using CloudEvents Avro converter";
            byte[] valueBytes = cloudEventsConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using Avro deserializer";
            avroSchemaAndValue = cloudEventsConverter.toConnectData(record.topic(), valueBytes);
            msg = "inspecting all required CloudEvents fields in the value";
            Struct avroValue = (Struct)avroSchemaAndValue.value();
            Assertions.assertThat((Object)avroValue.get("id")).isNotNull();
            Assertions.assertThat((String)avroValue.getString("source")).isEqualTo((Object)("/debezium/" + connectorName + "/" + serverName));
            Assertions.assertThat((Object)avroValue.get("specversion")).isEqualTo((Object)"1.0");
            Assertions.assertThat((Object)avroValue.get("type")).isEqualTo((Object)("io.debezium." + connectorName + ".datachangeevent"));
            Assertions.assertThat((Object)avroValue.get("datacontenttype")).isEqualTo((Object)"application/avro");
            Assertions.assertThat((String)avroValue.getString("dataschema")).startsWith((CharSequence)"http://fake-url/schemas/ids/");
            Assertions.assertThat((Object)avroValue.get("time")).isNotNull();
            Assertions.assertThat((Object)avroValue.get("data")).isNotNull();
            msg = "inspecting required CloudEvents extension attributes in the value";
            Assertions.assertThat((Object)avroValue.get(CloudEventsConverter.adjustExtensionName((String)"op"))).isNotNull();
            Assertions.assertThat((Object)avroValue.get(CloudEventsConverter.adjustExtensionName((String)"ts_ms"))).isNotNull();
            if (hasTransaction) {
                msg = "inspecting transaction metadata attributes";
                Assertions.assertThat((Object)avroValue.get("iodebeziumtxid")).isNotNull();
                Assertions.assertThat((Object)avroValue.get("iodebeziumtxtotalorder")).isNotNull();
                Assertions.assertThat((Object)avroValue.get("iodebeziumtxdatacollectionorder")).isNotNull();
            }
            msg = "inspecting the data field in the value";
            Struct avroDataField = avroValue.getStruct("data");
            Assertions.assertThat((Object)avroDataField.schema().field("after")).isNotNull();
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            if (avroSchemaAndValue != null) {
                Testing.print("  value to/from Avro: " + SchemaUtil.asString((Object)avroSchemaAndValue.value()));
            }
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    public static void shouldConvertToCloudEventsInJsonWithMetadataInHeaders(SourceRecord record, String connectorName, String serverName) throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serializer.type", "json");
        config.put("data.serializer.type", "json");
        config.put("metadata.location", "header");
        CloudEventsConverter cloudEventsConverter = new CloudEventsConverter();
        cloudEventsConverter.configure(config, false);
        JsonNode valueJson = null;
        String msg = null;
        try {
            msg = "converting value using CloudEvents JSON converter";
            byte[] valueBytes = cloudEventsConverter.fromConnectData(record.topic(), (Headers)CloudEventsConverterTest.convertHeadersFor(record), record.valueSchema(), record.value());
            msg = "deserializing value using CE deserializer";
            SchemaAndValue ceValue = cloudEventsConverter.toConnectData(record.topic(), valueBytes);
            msg = "deserializing value using JSON deserializer";
            try (JsonDeserializer jsonDeserializer = new JsonDeserializer();){
                jsonDeserializer.configure(Collections.emptyMap(), false);
                valueJson = jsonDeserializer.deserialize(record.topic(), valueBytes);
            }
            msg = "inspecting all required CloudEvents fields in the value";
            Assertions.assertThat((Iterable)valueJson.get("id")).isNotNull();
            Assertions.assertThat((String)valueJson.get("source").asText()).isEqualTo((Object)("/debezium/" + connectorName + "/" + serverName));
            Assertions.assertThat((String)valueJson.get("specversion").asText()).isEqualTo((Object)"1.0");
            Assertions.assertThat((Iterable)valueJson.get("dataschema")).isNull();
            Assertions.assertThat((String)valueJson.get("type").asText()).isEqualTo((Object)("io.debezium." + connectorName + ".datachangeevent"));
            Assertions.assertThat((String)valueJson.get("datacontenttype").asText()).isEqualTo((Object)"application/json");
            Assertions.assertThat((Iterable)valueJson.get("time")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("data")).isNotNull();
            msg = "inspecting required CloudEvents extension attributes for Debezium";
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumop")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumtsms")).isNotNull();
            msg = "inspecting transaction metadata attributes";
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxid")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxtotalorder")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxdatacollectionorder")).isNotNull();
            msg = "inspecting the data field in the value";
            JsonNode dataJson = valueJson.get("data");
            Assertions.assertThat((Iterable)dataJson.get("schema")).isNotNull();
            Assertions.assertThat((Iterable)dataJson.get("payload")).isNotNull();
            Assertions.assertThat((String)dataJson.get("payload").get("someField1").textValue()).isEqualTo((Object)"some value 1");
            Assertions.assertThat((int)dataJson.get("payload").get("someField2").intValue()).isEqualTo(7005);
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            Testing.print("  value deserialized from CloudEvents in JSON: " + CloudEventsConverterTest.prettyJson(valueJson));
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    private static RecordHeaders convertHeadersFor(SourceRecord record) throws IOException {
        try (JsonConverter jsonHeaderConverter = new JsonConverter();){
            HashMap<String, Object> jsonHeaderConverterConfig = new HashMap<String, Object>();
            jsonHeaderConverterConfig.put("schemas.enable", true);
            jsonHeaderConverterConfig.put("converter.type", "header");
            jsonHeaderConverter.configure(jsonHeaderConverterConfig);
            org.apache.kafka.connect.header.Headers headers = record.headers();
            RecordHeaders result = new RecordHeaders();
            if (headers != null) {
                String topic = record.topic();
                for (Header header : headers) {
                    String key = header.key();
                    byte[] rawHeader = jsonHeaderConverter.fromConnectHeader(topic, key, header.schema(), header.value());
                    result.add(key, rawHeader);
                }
            }
            RecordHeaders recordHeaders = result;
            return recordHeaders;
        }
    }

    private static String prettyJson(JsonNode json) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
        }
        catch (Throwable t) {
            Testing.printError(t);
            Assert.fail((String)t.getMessage());
            assert (false) : "Will not get here";
            return null;
        }
    }
}

