/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SelectorsTest {
    private Predicate<TableId> filter;

    @Test
    public void shouldCreateFilterWithAllLists() {
        this.filter = Selectors.tableSelector().includeDatabases("connector_test").excludeDatabases("").includeTables("").excludeTables("").build();
        this.assertAllowed(this.filter, "connector_test", "A");
        this.assertAllowed(this.filter, "connector_test", "B");
        this.assertNotAllowed(this.filter, "other_test", "A");
        this.assertNotAllowed(this.filter, "other_test", "B");
    }

    @Test
    public void shouldCreateFilterWithDatabaseWhitelistAndTableWhitelist() {
        this.filter = Selectors.tableSelector().includeDatabases("db1,db2").includeTables("db1\\.A,db1\\.B,db2\\.C").build();
        this.assertAllowed(this.filter, "db1", "A");
        this.assertAllowed(this.filter, "db1", "B");
        this.assertNotAllowed(this.filter, "db1", "D");
        this.assertNotAllowed(this.filter, "db1", "E");
        this.assertNotAllowed(this.filter, "db1", "F");
        this.assertAllowed(this.filter, "db2", "C");
        this.assertNotAllowed(this.filter, "db2", "G");
        this.assertNotAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseWhitelistAndTableBlacklist() {
        this.filter = Selectors.tableSelector().includeDatabases("db1,db2").excludeTables("db1\\.A,db1\\.B,db2\\.C").build();
        this.assertNotAllowed(this.filter, "db1", "A");
        this.assertNotAllowed(this.filter, "db1", "B");
        this.assertAllowed(this.filter, "db1", "D");
        this.assertAllowed(this.filter, "db1", "E");
        this.assertAllowed(this.filter, "db1", "F");
        this.assertNotAllowed(this.filter, "db2", "C");
        this.assertAllowed(this.filter, "db2", "G");
        this.assertAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseBlacklistAndTableWhitelist() {
        this.filter = Selectors.tableSelector().excludeDatabases("db3,db4").includeTables("db1\\.A,db1\\.B,db2\\.C").build();
        this.assertAllowed(this.filter, "db1", "A");
        this.assertAllowed(this.filter, "db1", "B");
        this.assertNotAllowed(this.filter, "db1", "D");
        this.assertNotAllowed(this.filter, "db1", "E");
        this.assertNotAllowed(this.filter, "db1", "F");
        this.assertAllowed(this.filter, "db2", "C");
        this.assertNotAllowed(this.filter, "db2", "G");
        this.assertNotAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseBlacklistAndTableBlacklist() {
        this.filter = Selectors.tableSelector().excludeDatabases("db3,db4").excludeTables("db1\\.A,db1\\.B,db2\\.C").build();
        this.assertNotAllowed(this.filter, "db1", "A");
        this.assertNotAllowed(this.filter, "db1", "B");
        this.assertAllowed(this.filter, "db1", "D");
        this.assertAllowed(this.filter, "db1", "E");
        this.assertAllowed(this.filter, "db1", "F");
        this.assertNotAllowed(this.filter, "db2", "C");
        this.assertAllowed(this.filter, "db2", "G");
        this.assertAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithNoDatabaseFilterAndTableWhitelist() {
        this.filter = Selectors.tableSelector().includeTables("db1\\.A,db1\\.B,db2\\.C").build();
        this.assertAllowed(this.filter, "db1", "A");
        this.assertAllowed(this.filter, "db1", "B");
        this.assertNotAllowed(this.filter, "db1", "D");
        this.assertNotAllowed(this.filter, "db1", "E");
        this.assertNotAllowed(this.filter, "db1", "F");
        this.assertAllowed(this.filter, "db2", "C");
        this.assertNotAllowed(this.filter, "db2", "G");
        this.assertNotAllowed(this.filter, "db2", "H");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithNoDatabaseFilterAndTableBlacklist() {
        this.filter = Selectors.tableSelector().excludeTables("db1\\.A,db1\\.B,db2\\.C").build();
        this.assertNotAllowed(this.filter, "db1", "A");
        this.assertNotAllowed(this.filter, "db1", "B");
        this.assertAllowed(this.filter, "db1", "D");
        this.assertAllowed(this.filter, "db1", "E");
        this.assertAllowed(this.filter, "db1", "F");
        this.assertNotAllowed(this.filter, "db2", "C");
        this.assertAllowed(this.filter, "db2", "G");
        this.assertAllowed(this.filter, "db2", "H");
        this.assertAllowed(this.filter, "db3", "A");
        this.assertAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseWhitelistAndNoTableFilter() {
        this.filter = Selectors.tableSelector().includeDatabases("db1,db2").build();
        this.assertAllowed(this.filter, "db1", "A");
        this.assertAllowed(this.filter, "db2", "A");
        this.assertNotAllowed(this.filter, "db3", "A");
        this.assertNotAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithDatabaseBlacklistAndNoTableFilter() {
        this.filter = Selectors.tableSelector().excludeDatabases("db1,db2").build();
        this.assertNotAllowed(this.filter, "db1", "A");
        this.assertNotAllowed(this.filter, "db2", "A");
        this.assertAllowed(this.filter, "db3", "A");
        this.assertAllowed(this.filter, "db4", "A");
    }

    @Test
    public void shouldCreateFilterWithSchemaBlacklistAndNoTableFilter() {
        this.filter = Selectors.tableSelector().excludeSchemas("sc1,sc2").build();
        this.assertNotAllowed(this.filter, "db1", "sc1", "A");
        this.assertNotAllowed(this.filter, "db2", "sc2", "A");
        this.assertAllowed(this.filter, "db1", "sc3", "A");
        this.assertAllowed(this.filter, "db2", "sc4", "A");
    }

    @Test
    public void shouldCreateFilterWithSchemaWhitelistAndNoTableFilter() {
        this.filter = Selectors.tableSelector().includeSchemas("sc1,sc2").build();
        this.assertAllowed(this.filter, "db1", "sc1", "A");
        this.assertAllowed(this.filter, "db2", "sc2", "A");
        this.assertNotAllowed(this.filter, "db1", "sc3", "A");
        this.assertNotAllowed(this.filter, "db2", "sc4", "A");
    }

    @Test
    public void shouldCreateFilterWithSchemaWhitelistAndTableWhitelist() {
        this.filter = Selectors.tableSelector().includeSchemas("sc1,sc2").includeTables("db\\.sc1\\.A,db\\.sc2\\.B").build();
        this.assertAllowed(this.filter, "db", "sc1", "A");
        this.assertNotAllowed(this.filter, "db", "sc1", "B");
        this.assertAllowed(this.filter, "db", "sc2", "B");
        this.assertNotAllowed(this.filter, "db", "sc2", "A");
        this.assertNotAllowed(this.filter, "db", "sc1", "C");
        this.assertNotAllowed(this.filter, "db2", "sc2", "D");
        this.assertNotAllowed(this.filter, "db", "sc3", "A");
        this.assertNotAllowed(this.filter, "db2", "sc4", "B");
    }

    protected void assertAllowed(Predicate<TableId> filter, String dbName, String tableName) {
        TableId id = new TableId(dbName, null, tableName);
        Assertions.assertThat((boolean)filter.test(id)).isTrue();
    }

    protected void assertAllowed(Predicate<TableId> filter, String dbName, String schemaName, String tableName) {
        TableId id = new TableId(dbName, schemaName, tableName);
        Assertions.assertThat((boolean)filter.test(id)).isTrue();
    }

    protected void assertNotAllowed(Predicate<TableId> filter, String dbName, String tableName) {
        TableId id = new TableId(dbName, null, tableName);
        Assertions.assertThat((boolean)filter.test(id)).isFalse();
    }

    protected void assertNotAllowed(Predicate<TableId> filter, String dbName, String schemaName, String tableName) {
        TableId id = new TableId(dbName, schemaName, tableName);
        Assertions.assertThat((boolean)filter.test(id)).isFalse();
    }
}

