/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.partitions;

import io.debezium.data.Envelope;
import io.debezium.transforms.partitions.ComputePartition;
import io.debezium.transforms.partitions.ComputePartitionException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ComputePartitionTest {
    public static final Schema VALUE_SCHEMA = SchemaBuilder.struct().name("mysql-server-1.inventory.products.Value").field("id", Schema.INT64_SCHEMA).field("price", Schema.FLOAT32_SCHEMA).field("product", Schema.STRING_SCHEMA).build();
    private final ComputePartition<SourceRecord> computePartitionTransformation = new ComputePartition();

    @Test
    public void correctComputeKafkaPartitionBasedOnConfiguredFieldOnCreateAndUpdateMySqlEvents() {
        this.configureTransformation("inventory.products:product", "inventory.products:2");
        SourceRecord eventRecord = this.buildSourceRecord("mysql", "inventory", null, "products", this.productRow(1L, 1.0f, "APPLE"), Envelope.Operation.CREATE);
        SourceRecord transformed = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Integer)transformed.kafkaPartition()).isZero();
    }

    @Test
    public void correctComputeKafkaPartitionBasedOnConfiguredFieldOnCreateAndUpdatePostgreSQLEvents() {
        this.configureTransformation("inventory.products:product", "inventory.products:2");
        SourceRecord eventRecord = this.buildSourceRecord("postgres", "postgres", "inventory", "products", this.productRow(1L, 1.0f, "APPLE"), Envelope.Operation.CREATE);
        SourceRecord transformed = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Integer)transformed.kafkaPartition()).isZero();
    }

    @Test
    public void correctComputeKafkaPartitionBasedOnConfiguredFieldOnDeleteEvents() {
        this.configureTransformation("inventory.products:product", "inventory.products:2");
        SourceRecord eventRecord = this.buildSourceRecord("mysql", "inventory", null, "products", this.productRow(1L, 1.0f, "APPLE"), Envelope.Operation.DELETE);
        SourceRecord transformed = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Integer)transformed.kafkaPartition()).isZero();
    }

    @Test
    public void partitionNotComputedOnTruncateEvent() {
        this.configureTransformation("inventory.products:product", "inventory.products:2");
        SourceRecord eventRecord = this.buildSourceRecord("mysql", "inventory", null, "products", this.productRow(1L, 1.0f, "APPLE"), Envelope.Operation.TRUNCATE);
        SourceRecord transformed = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Integer)transformed.kafkaPartition()).isEqualTo((Object)eventRecord.kafkaPartition());
    }

    @Test
    public void rowWithSameConfiguredFieldValueWillHaveTheSamePartition() {
        this.configureTransformation("inventory.products:product", "inventory.products:2");
        SourceRecord eventRecord1 = this.buildSourceRecord("mysql", "inventory", null, "products", this.productRow(1L, 1.0f, "APPLE"), Envelope.Operation.CREATE);
        SourceRecord transformed1 = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord1);
        SourceRecord eventRecord2 = this.buildSourceRecord("mysql", "inventory", null, "products", this.productRow(2L, 2.0f, "APPLE"), Envelope.Operation.CREATE);
        SourceRecord transformed2 = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord2);
        Assertions.assertThat((Integer)transformed1.kafkaPartition()).isZero();
        Assertions.assertThat((Integer)transformed2.kafkaPartition()).isZero();
    }

    @Test
    public void rowWithDifferentConfiguredFieldValueWillHaveDifferentPartition() {
        this.configureTransformation("inventory.products:product", "inventory.products:2");
        SourceRecord eventRecord1 = this.buildSourceRecord("mysql", "inventory", null, "products", this.productRow(1L, 1.0f, "APPLE"), Envelope.Operation.CREATE);
        SourceRecord transformed1 = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord1);
        SourceRecord eventRecord2 = this.buildSourceRecord("mysql", "inventory", null, "products", this.productRow(3L, 0.95f, "BANANA"), Envelope.Operation.CREATE);
        SourceRecord transformed2 = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord2);
        Assertions.assertThat((Integer)transformed1.kafkaPartition()).isNotEqualTo((Object)transformed2.kafkaPartition());
    }

    @Test
    public void notConsistentConfigurationSizeWillThrowConnectionException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.configureTransformation("inventory.orders:purchaser,inventory.products:product", "purchaser:2")).isInstanceOf(ComputePartitionException.class)).hasMessageContaining("Unable to validate config. partition.data-collections.partition.num.mappings and partition.data-collections.field.mappings has different number of table defined");
    }

    @Test
    public void notConsistentConfigurationWillThrowConnectionException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.configureTransformation("inventory.orders:purchaser,inventory.products:product", "prod:2,purchaser:2")).isInstanceOf(ComputePartitionException.class)).hasMessageContaining("Unable to validate config. partition.data-collections.partition.num.mappings and partition.data-collections.field.mappings has different tables defined");
    }

    @Test
    public void negativeHashCodeValueWillBeCorrectlyManaged() {
        this.configureTransformation("inventory.products:product", "inventory.products:3");
        SourceRecord eventRecord1 = this.buildSourceRecord("mysql", "inventory", null, "products", this.productRow(1L, 1.0f, "orange"), Envelope.Operation.CREATE);
        SourceRecord transformed1 = (SourceRecord)this.computePartitionTransformation.apply((ConnectRecord)eventRecord1);
        Assertions.assertThat((Integer)transformed1.kafkaPartition()).isEqualTo(1);
    }

    @Test
    public void zeroAsPartitionNumberWillThrowConnectionException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.configureTransformation("inventory.orders:purchaser,inventory.products:products", "inventory.products:0,inventory.orders:2")).isInstanceOf(ComputePartitionException.class)).hasMessageContaining("Unable to validate config. partition.data-collections.partition.num.mappings: partition number for 'inventory.products' must be positive");
    }

    @Test
    public void negativeAsPartitionNumberWillThrowConnectionException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.configureTransformation("inventory.orders:purchaser,inventory.products:products", "inventory.products:-3,inventory.orders:2")).isInstanceOf(ComputePartitionException.class)).hasMessageContaining("Unable to validate config. partition.data-collections.partition.num.mappings: partition number for 'inventory.products' must be positive");
    }

    private SourceRecord buildSourceRecord(String connector, String db, String schema, String tableName, Struct row, Envelope.Operation operation) {
        String dataCollectionFieldName = "mongodb".equals(connector) ? "collection" : "table";
        SchemaBuilder sourceSchemaBuilder = SchemaBuilder.struct().name("source").field("connector", Schema.STRING_SCHEMA).field("db", Schema.STRING_SCHEMA).field(dataCollectionFieldName, Schema.STRING_SCHEMA);
        if (schema != null) {
            sourceSchemaBuilder.field("schema", Schema.STRING_SCHEMA);
        }
        Schema sourceSchema = sourceSchemaBuilder.build();
        Envelope createEnvelope = Envelope.defineSchema().withName("mysql-server-1.inventory.product.Envelope").withRecord(VALUE_SCHEMA).withSource(sourceSchema).build();
        Struct source = new Struct(sourceSchema);
        source.put("connector", (Object)connector);
        source.put("db", (Object)db);
        source.put(dataCollectionFieldName, (Object)tableName);
        if (schema != null) {
            source.put("schema", (Object)schema);
        }
        Struct payload = createEnvelope.create((Object)row, source, Instant.now());
        switch (operation) {
            case CREATE: 
            case UPDATE: 
            case READ: {
                payload = createEnvelope.create((Object)row, source, Instant.now());
                break;
            }
            case DELETE: {
                payload = createEnvelope.delete((Object)row, source, Instant.now());
                break;
            }
            case TRUNCATE: {
                payload = createEnvelope.truncate(source, Instant.now());
            }
        }
        return new SourceRecord(new HashMap(), new HashMap(), "prefix.inventory.products", createEnvelope.schema(), (Object)payload);
    }

    private void configureTransformation(String tableFieldMapping, String tablePartitionNumMapping) {
        this.computePartitionTransformation.configure(Map.of("partition.data-collections.field.mappings", tableFieldMapping, "partition.data-collections.partition.num.mappings", tablePartitionNumMapping));
    }

    private Struct productRow(long id, float price, String name) {
        return new Struct(VALUE_SCHEMA).put("id", (Object)id).put("price", (Object)Float.valueOf(price)).put("product", (Object)name);
    }
}

