/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.doc.FixFor;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.schema.UnicodeReplacementFunction;
import io.debezium.spi.common.ReplacementFunction;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SchemaNameAdjusterTest {
    private ReplacementFunction underscoreReplacement;
    private ReplacementFunction unicodeReplacement;

    @Before
    public void before() {
        this.underscoreReplacement = ReplacementFunction.UNDERSCORE_REPLACEMENT;
        this.unicodeReplacement = new UnicodeReplacementFunction();
    }

    @Test
    public void shouldDetermineValidFirstCharacters() {
        String validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        for (int i = 0; i != validChars.length(); ++i) {
            Assertions.assertThat((boolean)this.underscoreReplacement.isValidFirstCharacter(validChars.charAt(i))).isTrue();
        }
    }

    @Test
    public void shouldDetermineValidNonFirstCharacters() {
        String validChars = ".abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        for (int i = 0; i != validChars.length(); ++i) {
            Assertions.assertThat((boolean)this.underscoreReplacement.isValidNonFirstCharacter(validChars.charAt(i))).isTrue();
        }
    }

    @Test
    public void shouldConsiderValidFullnames() {
        this.assertValidFullname("test_server.connector_test.products.Key");
        this.assertValidFullname("t1234.connector_test.products.Key");
    }

    @Test
    public void shouldConsiderInvalidFullnames() {
        this.assertNotValidFullname("test-server.connector_test.products.Key");
    }

    @Test
    public void shouldConsiderInvalidFirstCharacters() {
        int i;
        String invalidChars = "1_\u8bed\u8a00";
        for (i = 0; i < invalidChars.length(); ++i) {
            Assertions.assertThat((boolean)this.unicodeReplacement.isValidFirstCharacter(invalidChars.charAt(i))).isFalse();
        }
        invalidChars = "_\u8bed\u8a00";
        for (i = 0; i < invalidChars.length(); ++i) {
            Assertions.assertThat((boolean)this.unicodeReplacement.isValidNonFirstCharacter(invalidChars.charAt(i))).isFalse();
        }
    }

    @Test
    public void shouldConvertInvalidCharactersToUnicode() {
        SchemaNameAdjuster unicodeAdjuster = SchemaNameAdjuster.AVRO_UNICODE;
        String originName = "_hello_\u8bed\u8a00.";
        String expectedName = "_u005fhello_u005f_u8bed_u8a00.";
        Assertions.assertThat((String)unicodeAdjuster.adjust(originName)).isEqualTo((Object)expectedName);
    }

    @Test
    public void shouldReportReplacementEveryTime() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        SchemaNameAdjuster.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.create((String)"_", (SchemaNameAdjuster.ReplacementOccurred)handler);
        for (int i = 0; i != 20; ++i) {
            adjuster.adjust("some-invalid-fullname$");
        }
        Assertions.assertThat((int)counter.get()).isEqualTo(20);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(0);
    }

    @Test
    public void shouldReportReplacementOnlyOnce() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        SchemaNameAdjuster.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.create((String)"_", (SchemaNameAdjuster.ReplacementOccurred)handler.firstTimeOnly());
        for (int i = 0; i != 20; ++i) {
            adjuster.adjust("some-invalid-fullname$");
        }
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(0);
    }

    @Test
    public void shouldReportConflictReplacement() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        SchemaNameAdjuster.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.create((String)"_", (SchemaNameAdjuster.ReplacementOccurred)handler.firstTimeOnly());
        adjuster.adjust("some-invalid-fullname$");
        adjuster.adjust("some-invalid%fullname_");
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(1);
    }

    @Test
    @FixFor(value={"DBZ-6559"})
    public void whenFirstCharIsInvalidAddUnderscoreBeforeInsteadOfReplacingIt() {
        SchemaNameAdjuster unicodeAdjuster = SchemaNameAdjuster.AVRO;
        Assertions.assertThat((String)unicodeAdjuster.adjust("24ColumnName")).isEqualTo((Object)"_24ColumnName");
        Assertions.assertThat((String)unicodeAdjuster.adjust("44ColumnName")).isEqualTo((Object)"_44ColumnName");
    }

    protected void assertValidFullname(String fullname) {
        Assertions.assertThat((boolean)SchemaNameAdjuster.isValidFullname((String)fullname)).isTrue();
    }

    protected void assertNotValidFullname(String fullname) {
        Assertions.assertThat((boolean)SchemaNameAdjuster.isValidFullname((String)fullname)).isFalse();
    }
}

