/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.data.Envelope;
import io.debezium.data.SourceRecordStats;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class KeyValueStore {
    private final List<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
    private final Map<TableId, Collection> collectionsByTableId = new HashMap<TableId, Collection>();
    private final Function<String, TableId> tableIdFromTopic;

    protected static Function<String, TableId> prefixedWith(String prefix) {
        int index = prefix.length();
        return topicName -> {
            if (topicName.startsWith(prefix) && topicName.length() > index) {
                return TableId.parse((String)topicName.substring(index));
            }
            return null;
        };
    }

    protected static Function<String, TableId> fromRegex(String regex, int groupNumber) {
        Pattern pattern = Pattern.compile(regex);
        return topicName -> {
            Matcher m = pattern.matcher((CharSequence)topicName);
            String fullyQualified = m.group(groupNumber);
            return fullyQualified != null ? TableId.parse((String)fullyQualified) : null;
        };
    }

    public static KeyValueStore createForTopicsMatching(String regex, int groupNumber) {
        return new KeyValueStore(KeyValueStore.fromRegex(regex, groupNumber));
    }

    public static KeyValueStore createForTopicsBeginningWith(String prefix) {
        return new KeyValueStore(KeyValueStore.prefixedWith(prefix));
    }

    protected KeyValueStore(Function<String, TableId> tableIdFromTopic) {
        this.tableIdFromTopic = tableIdFromTopic;
    }

    public void add(SourceRecord record) {
        TableId tableId = this.tableIdFromTopic.apply(record.topic());
        if (tableId != null) {
            this.sourceRecords.add(record);
            this.getOrCreate(tableId).add(record);
        }
    }

    public List<SourceRecord> sourceRecords() {
        return this.sourceRecords;
    }

    public Collection collection(String fullyQualifiedName) {
        return this.collection(TableId.parse((String)fullyQualifiedName));
    }

    public Collection collection(String catalog, String tableName) {
        return this.collection(new TableId(catalog, null, tableName));
    }

    public Collection collection(TableId tableId) {
        return this.collectionsByTableId.get(tableId);
    }

    public Set<TableId> collections() {
        return Collections.unmodifiableSet(this.collectionsByTableId.keySet());
    }

    public Set<String> databases() {
        return this.collectionsByTableId.keySet().stream().map(TableId::catalog).collect(Collectors.toSet());
    }

    public int collectionCount() {
        return this.collectionsByTableId.size();
    }

    public Collection getOrCreate(TableId tableId) {
        return this.collectionsByTableId.computeIfAbsent(tableId, Collection::new);
    }

    protected static Struct keyFor(SourceRecord record) {
        return (Struct)record.key();
    }

    protected static Struct valueFor(SourceRecord record) {
        Struct envelope = (Struct)record.value();
        Field afterField = envelope.schema().field("after");
        if (afterField != null) {
            return envelope.getStruct(afterField.name());
        }
        return null;
    }

    protected static Struct sourceFor(SourceRecord record) {
        Struct envelope = (Struct)record.value();
        Field field = envelope.schema().field("source");
        if (field != null) {
            return envelope.getStruct(field.name());
        }
        return null;
    }

    public static class Collection {
        private final TableId id;
        private Schema keySchema = null;
        private Schema valueSchema = null;
        private final List<Schema> keySchemas = new ArrayList<Schema>();
        private final List<Schema> valueSchemas = new ArrayList<Schema>();
        private final Map<Struct, SourceRecord> valuesByKey = new HashMap<Struct, SourceRecord>();
        private final SourceRecordStats stats = new SourceRecordStats();

        protected Collection(TableId id) {
            this.id = id;
        }

        public TableId tableId() {
            return this.id;
        }

        public long numberOfKeySchemaChanges() {
            return this.keySchemas.size();
        }

        public long numberOfValueSchemaChanges() {
            return this.valueSchemas.size();
        }

        public long numberOfCreates() {
            return this.stats.numberOfCreates();
        }

        public long numberOfDeletes() {
            return this.stats.numberOfDeletes();
        }

        public long numberOfReads() {
            return this.stats.numberOfReads();
        }

        public long numberOfUpdates() {
            return this.stats.numberOfUpdates();
        }

        public long numberOfTombstones() {
            return this.stats.numberOfTombstones();
        }

        public int size() {
            return this.valuesByKey.size();
        }

        public int keySchemaChanges() {
            return this.keySchemas.size();
        }

        public int valueSchemaChanges() {
            return this.valueSchemas.size();
        }

        public Struct value(Struct key) {
            SourceRecord record = this.valuesByKey.get(key);
            return record != null ? KeyValueStore.valueFor(record) : null;
        }

        public void forEach(Consumer<SourceRecord> consumer) {
            this.valuesByKey.values().forEach(consumer);
        }

        protected void add(SourceRecord record) {
            if (record != null) {
                Struct key = KeyValueStore.keyFor(record);
                if (key == null) {
                    return;
                }
                Struct value = KeyValueStore.valueFor(record);
                if (value != null) {
                    Envelope.Operation op = Envelope.operationFor((SourceRecord)record);
                    if (op != null) {
                        switch (op) {
                            case READ: 
                            case CREATE: 
                            case UPDATE: {
                                this.valuesByKey.put((Struct)record.key(), record);
                                break;
                            }
                            case DELETE: {
                                this.valuesByKey.remove(key);
                            }
                        }
                    }
                } else {
                    this.valuesByKey.remove(key);
                }
                if (!record.keySchema().equals(this.keySchema)) {
                    this.keySchemas.add(record.keySchema());
                    this.keySchema = record.keySchema();
                }
                if (!record.valueSchema().equals(this.valueSchema)) {
                    this.valueSchemas.add(record.valueSchema());
                    this.valueSchema = record.valueSchema();
                }
                this.stats.accept(record);
            }
        }
    }
}

