/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.data.Envelope;
import io.debezium.pipeline.signal.SignalRecord;
import io.debezium.pipeline.signal.channels.SourceSignalChannel;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SourceSignalChannelTest {
    @Test
    public void shouldExecuteFromEnvelope() throws Exception {
        SourceSignalChannel sourceSignalChannel = new SourceSignalChannel();
        sourceSignalChannel.init(this.config());
        Schema afterSchema = SchemaBuilder.struct().name("signal").field("col1", Schema.OPTIONAL_STRING_SCHEMA).field("col2", Schema.OPTIONAL_STRING_SCHEMA).field("col3", Schema.OPTIONAL_STRING_SCHEMA).build();
        Envelope env = Envelope.defineSchema().withName("someName").withRecord(afterSchema).withSource(SchemaBuilder.struct().name("source").build()).build();
        Struct record = new Struct(afterSchema);
        record.put("col1", (Object)"log1");
        record.put("col2", (Object)"custom");
        record.put("col3", (Object)"{\"v\": 5}");
        sourceSignalChannel.process(env.create((Object)record, null, null));
        List signalRecords = sourceSignalChannel.read();
        Assertions.assertThat((List)signalRecords).hasSize(1);
        Assertions.assertThat((String)((SignalRecord)signalRecords.get(0)).getData()).isEqualTo((Object)"{\"v\": 5}");
    }

    @Test
    public void shouldIgnoreInvalidEnvelope() throws Exception {
        SourceSignalChannel sourceSignalChannel = new SourceSignalChannel();
        sourceSignalChannel.init(this.config());
        Schema afterSchema = SchemaBuilder.struct().name("signal").field("col1", Schema.OPTIONAL_STRING_SCHEMA).field("col2", Schema.OPTIONAL_STRING_SCHEMA).build();
        Envelope env = Envelope.defineSchema().withName("someName").withRecord(afterSchema).withSource(SchemaBuilder.struct().name("source").build()).build();
        Struct record = new Struct(afterSchema);
        record.put("col1", (Object)"log1");
        record.put("col2", (Object)"custom");
        sourceSignalChannel.process(env.create((Object)record, null, null));
        Assertions.assertThat((List)sourceSignalChannel.read()).hasSize(0);
        sourceSignalChannel.process(record);
        Assertions.assertThat((List)sourceSignalChannel.read()).hasSize(0);
    }

    protected CommonConnectorConfig config() {
        return new CommonConnectorConfig(((Configuration.Builder)((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.SIGNAL_DATA_COLLECTION, "debezium.signal")).with(CommonConnectorConfig.TOPIC_PREFIX, "core")).build(), 0){

            protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
                return null;
            }

            public String getContextName() {
                return null;
            }

            public String getConnectorName() {
                return null;
            }
        };
    }
}

