/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.junit.Flaky;
import io.debezium.junit.ShouldFailWhen;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalFail
extends AnnotationBasedTestRule {
    private static final Logger FLAKY_LOGGER = LoggerFactory.getLogger(Flaky.class);
    private static final String JIRA_BASE_URL = "https://issues.redhat.com/browse/";

    public Statement apply(Statement base, Description description) {
        ShouldFailWhen conditionClass = this.hasAnnotation(description, ShouldFailWhen.class);
        if (conditionClass != null) {
            return this.failOnCondition(base, description, conditionClass);
        }
        Flaky flakyClass = this.hasAnnotation(description, Flaky.class);
        if (flakyClass != null) {
            return this.ignoreFlakyFailure(base, description, flakyClass);
        }
        return base;
    }

    private Statement failOnCondition(final Statement base, final Description description, ShouldFailWhen conditionClass) {
        try {
            final Supplier<Boolean> condition = conditionClass.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new Statement(){

                public void evaluate() throws Throwable {
                    Throwable failure = null;
                    try {
                        base.evaluate();
                    }
                    catch (Throwable t) {
                        failure = t;
                    }
                    if (((Boolean)condition.get()).booleanValue() && failure == null) {
                        Assert.fail((String)("Expected failing test for " + String.valueOf(description)));
                    } else if (((Boolean)condition.get()).booleanValue() && failure != null) {
                        System.out.println("Ignored failure for " + String.valueOf(description));
                    } else if (failure != null) {
                        throw failure;
                    }
                }
            };
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Statement ignoreFlakyFailure(final Statement base, final Description description, final Flaky flakyClass) {
        String failFlakyTestsProperty = System.getProperty("failFlakyTests");
        if (failFlakyTestsProperty == null || Boolean.valueOf(failFlakyTestsProperty).booleanValue()) {
            return base;
        }
        String flakyAttemptsProperty = System.getProperty("flaky.attempts", "1");
        final int attempts = Integer.parseInt(flakyAttemptsProperty);
        return new Statement(){

            public void evaluate() throws Throwable {
                for (int i = 0; i < attempts; ++i) {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (Throwable t) {
                        FLAKY_LOGGER.error("Ignored failure for {}, tracked with {}", new Object[]{description, ConditionalFail.this.issueUrl(flakyClass.value()), t});
                        continue;
                    }
                }
                Assume.assumeTrue((String)String.format("Flaky test %s#%s failed", description.getTestClass().getSimpleName(), description.getMethodName()), (boolean)false);
            }
        };
    }

    private String issueUrl(String jiraId) {
        return JIRA_BASE_URL + jiraId;
    }
}

