/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.junit.DatabaseVersionResolver;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipLongRunning;
import io.debezium.junit.SkipOnOS;
import io.debezium.junit.SkipWhenConnectorUnderTest;
import io.debezium.junit.SkipWhenConnectorsUnderTest;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.junit.SkipWhenDatabaseVersions;
import io.debezium.junit.SkipWhenJavaVersion;
import io.debezium.junit.SkipWhenKafkaVersion;
import io.debezium.util.JvmVersionUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class SkipTestRule
extends AnnotationBasedTestRule {
    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Statement apply(Statement base, Description description) {
        skipJavaVersionAnnotation = this.hasAnnotation(description, SkipWhenJavaVersion.class);
        if (skipJavaVersionAnnotation != null) {
            checkedVersion = skipJavaVersionAnnotation.value();
            actualVersion = JvmVersionUtil.getFeatureVersion();
            switch (1.$SwitchMap$io$debezium$junit$EqualityCheck[skipJavaVersionAnnotation.check().ordinal()]) {
                case 1: {
                    var6_9 = actualVersion == checkedVersion;
                }
                case 2: {
                    isSkippedVersion = actualVersion > checkedVersion;
                    break;
                }
                case 3: {
                    isSkippedVersion = actualVersion >= checkedVersion;
                    break;
                }
                case 4: {
                    isSkippedVersion = actualVersion < checkedVersion;
                    break;
                }
                case 5: {
                    isSkippedVersion = actualVersion <= checkedVersion;
                    break;
                }
                default: {
                    isSkippedVersion = false;
                }
            }
            if (isSkippedVersion) {
                return SkipTestRule.emptyStatement("Java version=" + actualVersion, description);
            }
        }
        if ((skipLongRunningAnnotation = this.hasAnnotation(description, SkipLongRunning.class)) != null) {
            skipLongRunning = System.getProperty("skipLongRunningTests");
            if (skipLongRunning == null) return SkipTestRule.emptyStatement(skipLongRunningAnnotation.value(), description);
            if (Boolean.valueOf(skipLongRunning).booleanValue()) {
                return SkipTestRule.emptyStatement(skipLongRunningAnnotation.value(), description);
            }
        }
        if ((skipOnOSAnnotation = this.hasAnnotation(description, SkipOnOS.class)) != null) {
            oses = skipOnOSAnnotation.value();
            osName = System.getProperty("os.name");
            if (osName != null && !osName.trim().isEmpty()) {
                for (String os : oses) {
                    if (!osName.toLowerCase().startsWith(os.toLowerCase())) continue;
                    return SkipTestRule.emptyStatement(skipOnOSAnnotation.description(), description);
                }
            }
        }
        if ((skipWhenKafkaVersionAnnotation = this.hasAnnotation(description, SkipWhenKafkaVersion.class)) != null) {
            kafkaVersion = skipWhenKafkaVersionAnnotation.value();
            check = skipWhenKafkaVersionAnnotation.check();
            try {
                stream = Testing.class.getResourceAsStream("/kafka/kafka-version.properties");
                try {
                    if (stream != null) {
                        properties = new Properties();
                        properties.load(stream);
                        version = properties.getProperty("version");
                        versionArray = version.split("\\.");
                        major = versionArray.length >= 1 ? Integer.parseInt(versionArray[0]) : 0;
                        minor = versionArray.length >= 2 ? Integer.parseInt(versionArray[1]) : 1;
                        patch = versionArray.length >= 3 ? Integer.parseInt(versionArray[2]) : 2;
                        switch (1.$SwitchMap$io$debezium$junit$EqualityCheck[check.ordinal()]) {
                            case 4: {
                                if (!kafkaVersion.isLessThan(major, minor, patch)) ** break;
                                var16_34 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var16_34;
                            }
                            case 5: {
                                if (!kafkaVersion.isLessThanOrEqualTo(major, minor, patch)) ** break;
                                var16_35 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var16_35;
                            }
                            case 1: {
                                if (!kafkaVersion.isEqualTo(major, minor, patch)) ** break;
                                var16_36 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var16_36;
                            }
                            case 3: {
                                if (!kafkaVersion.isGreaterThanOrEqualTo(major, minor, patch)) ** break;
                                var16_37 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var16_37;
                            }
                            case 2: {
                                if (!kafkaVersion.isGreaterThan(major, minor, patch)) ** break;
                                var16_38 = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                                return var16_38;
                            }
                        }
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException stream) {
                // empty catch block
            }
        }
        if ((connectorUnderTestAnnotation = this.hasAnnotation(description, SkipWhenConnectorUnderTest.class)) != null && this.isSkippedByConnectorUnderTest(description, connectorUnderTestAnnotation)) {
            return SkipTestRule.emptyStatement("Connector under test " + String.valueOf((Object)connectorUnderTestAnnotation.value()), description);
        }
        connectorsUnderTestAnnotation = this.hasAnnotation(description, SkipWhenConnectorsUnderTest.class);
        if (connectorsUnderTestAnnotation != null) {
            for (SkipWhenConnectorUnderTest connector : connectorsUnderTestAnnotation.value()) {
                if (!this.isSkippedByConnectorUnderTest(description, connector)) continue;
                return SkipTestRule.emptyStatement("Connector under test " + String.valueOf((Object)connector.value()), description);
            }
        }
        if ((skipWhenDatabaseVersions = this.hasAnnotation(description, SkipWhenDatabaseVersions.class)) != null) {
            for (SkipWhenDatabaseVersion skipWhenDatabaseVersion : skipWhenDatabaseVersions.value()) {
                if (!this.isSkippedByDatabaseVersion(skipWhenDatabaseVersion)) continue;
                return SkipTestRule.emptyStatement(skipWhenDatabaseVersion.reason(), description);
            }
        }
        if ((skipWhenDatabaseVersion = this.hasAnnotation(description, SkipWhenDatabaseVersion.class)) == null) return base;
        if (this.isSkippedByDatabaseVersion(skipWhenDatabaseVersion) == false) return base;
        return SkipTestRule.emptyStatement(skipWhenDatabaseVersion.reason(), description);
    }

    public boolean isSkippedByConnectorUnderTest(Description description, SkipWhenConnectorUnderTest connectorUnderTestAnnotation) {
        boolean isConnectorUnderTest;
        switch (connectorUnderTestAnnotation.check()) {
            case EQUAL: {
                isConnectorUnderTest = connectorUnderTestAnnotation.value().isEqualTo(description.getClassName());
                break;
            }
            default: {
                isConnectorUnderTest = false;
            }
        }
        return isConnectorUnderTest;
    }

    private boolean isSkippedByDatabaseVersion(SkipWhenDatabaseVersion skipWhenDatabaseVersion) {
        EqualityCheck equalityCheck = skipWhenDatabaseVersion.check();
        int major = skipWhenDatabaseVersion.major();
        int minor = skipWhenDatabaseVersion.minor();
        int patch = skipWhenDatabaseVersion.patch();
        Reflections reflections = new Reflections("io.debezium", new Scanner[0]);
        Set resolvers = reflections.getSubTypesOf(DatabaseVersionResolver.class);
        Class resolverClass = resolvers.stream().findFirst().orElse(null);
        if (resolverClass != null) {
            try {
                DatabaseVersionResolver resolver = (DatabaseVersionResolver)resolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DatabaseVersionResolver.DatabaseVersion dbVersion = resolver.getVersion();
                if (dbVersion != null) {
                    switch (equalityCheck) {
                        case LESS_THAN: {
                            return dbVersion.isLessThan(major, minor, patch);
                        }
                        case LESS_THAN_OR_EQUAL: {
                            return dbVersion.isLessThanEqualTo(major, minor, patch);
                        }
                        case EQUAL: {
                            return dbVersion.isEqualTo(major, minor, patch);
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            return dbVersion.isGreaterThanEqualTo(major, minor, patch);
                        }
                        case GREATER_THAN: {
                            return dbVersion.isGreaterThan(major, minor, patch);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

