/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.data.Envelope;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;

public abstract class AbstractExtractStateTest {
    protected static final String DROP_TOMBSTONES = "drop.tombstones";
    protected static final String HANDLE_DELETES = "delete.handling.mode";
    protected static final String HANDLE_TOMBSTONE_DELETES = "delete.tombstone.handling.mode";
    protected static final String ROUTE_BY_FIELD = "route.by.field";
    protected static final String ADD_FIELDS = "add.fields";
    protected static final String ADD_HEADERS = "add.headers";
    protected static final String ADD_FIELDS_PREFIX = "add.fields.prefix";
    protected static final String ADD_HEADERS_PREFIX = "add.headers.prefix";
    protected static final String DROP_FIELDS_HEADER_NAME = "drop.fields.header.name";
    protected static final String DROP_FIELDS_FROM_KEY = "drop.fields.from.key";
    protected static final String DROP_FIELDS_KEEP_SCHEMA_COMPATIBLE = "drop.fields.keep.schema.compatible";
    Schema idSchema = SchemaBuilder.int8().parameters(Collect.hashMapOf((Object)"__debezium.source.column.name", (Object)"id", (Object)"__debezium.source.column.type", (Object)"int")).build();
    Schema nameSchema = SchemaBuilder.string().parameters(Collect.hashMapOf((Object)"__debezium.source.column.name", (Object)"name", (Object)"__debezium.source.column.type", (Object)"varchar", (Object)"__debezium.source.column.length", (Object)"255")).build();
    protected final Schema recordSchema = SchemaBuilder.struct().field("id", this.idSchema).field("name", this.nameSchema).build();
    protected final Schema sourceSchema = SchemaBuilder.struct().field("lsn", Schema.INT32_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("ts_us", Schema.OPTIONAL_INT64_SCHEMA).field("ts_ns", Schema.OPTIONAL_INT64_SCHEMA).field("db", Schema.OPTIONAL_STRING_SCHEMA).field("table", Schema.OPTIONAL_STRING_SCHEMA).build();
    protected final Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();

    protected SourceRecord createDeleteRecord() {
        Schema deleteSourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).field("db", Schema.OPTIONAL_STRING_SCHEMA).field("table", Schema.OPTIONAL_STRING_SCHEMA).build();
        Envelope deleteEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(deleteSourceSchema).build();
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(deleteSourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        source.put("db", (Object)"test_db");
        source.put("table", (Object)"test_table");
        Struct payload = deleteEnvelope.delete((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", deleteEnvelope.schema(), (Object)payload);
    }

    protected SourceRecord createTombstoneRecord() {
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
    }

    protected SourceRecord createTruncateRecord() {
        Struct source = this.createSource();
        source.put("lsn", (Object)1234);
        Struct truncate = this.envelope.truncate(source, Instant.ofEpochMilli(System.currentTimeMillis()));
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)truncate);
    }

    protected SourceRecord createCreateRecord() {
        Struct after = new Struct(this.recordSchema);
        Struct source = this.createSource();
        after.put("id", (Object)1);
        after.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        source.put("db", (Object)"test_db");
        source.put("table", (Object)"test_table");
        Struct payload = this.envelope.create((Object)after, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    protected SourceRecord createCreateRecordAddingColumn(String columnName, long columnValue) {
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", Schema.STRING_SCHEMA).field(columnName, Schema.OPTIONAL_INT64_SCHEMA).build();
        Struct after = new Struct(recordSchema);
        Struct source = this.createSource();
        after.put("id", (Object)1);
        after.put("name", (Object)"myRecord");
        after.put(columnName, (Object)columnValue);
        source.put("lsn", (Object)1234);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)after, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    protected SourceRecord createHeartbeatRecord() {
        Schema valueSchema = SchemaBuilder.struct().name("io.debezium.connector.common.Heartbeat").field("ts_ms", Schema.INT64_SCHEMA).build();
        Struct value = new Struct(valueSchema);
        Schema keySchema = SchemaBuilder.struct().name("op.with.heartbeat.Key").field("id", Schema.STRING_SCHEMA).build();
        Struct key = new Struct(keySchema).put("id", (Object)"123");
        return new SourceRecord(new HashMap(), new HashMap(), "op.with.heartbeat", keySchema, (Object)key, valueSchema, (Object)value);
    }

    protected SourceRecord createCreateRecordWithOptionalNull() {
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        Struct after = new Struct(recordSchema);
        Struct source = this.createSource();
        after.put("id", (Object)1);
        after.put("name", null);
        source.put("lsn", (Object)1234);
        Struct payload = envelope.create((Object)after, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    protected SourceRecord createCreateRecordWithKey() {
        Schema keySchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).build();
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        Struct key = new Struct(keySchema);
        Struct after = new Struct(recordSchema);
        Struct source = this.createSource();
        key.put("id", (Object)1);
        after.put("id", (Object)1);
        after.put("name", null);
        source.put("lsn", (Object)1234);
        Struct payload = envelope.create((Object)after, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", keySchema, (Object)key, envelope.schema(), (Object)payload);
    }

    protected SourceRecord createUpdateRecord() {
        Struct before = new Struct(this.recordSchema);
        Struct after = new Struct(this.recordSchema);
        Struct source = this.createSource();
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        source.put("db", (Object)"test_db");
        source.put("table", (Object)"test_table");
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct payload = this.envelope.update((Object)before, after, source, Instant.now());
        payload.put("transaction", (Object)transaction);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    protected SourceRecord createUpdateRecordWithOptionalNull() {
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Struct before = new Struct(recordSchema);
        Struct after = new Struct(recordSchema);
        Struct source = this.createSource();
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        before.put("id", (Object)1);
        before.put("name", null);
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct payload = envelope.update((Object)before, after, source, Instant.now());
        payload.put("transaction", (Object)transaction);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    protected SourceRecord createUpdateRecordWithKey() {
        Schema keySchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).build();
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Struct before = new Struct(recordSchema);
        Struct after = new Struct(recordSchema);
        Struct source = this.createSource();
        Struct key = new Struct(keySchema);
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        key.put("id", (Object)1);
        before.put("id", (Object)1);
        before.put("name", null);
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        source.put("db", (Object)"test_db");
        source.put("table", (Object)"test_table");
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct payload = envelope.update((Object)before, after, source, Instant.now());
        payload.put("transaction", (Object)transaction);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", keySchema, (Object)key, envelope.schema(), (Object)payload);
    }

    protected SourceRecord createComplexCreateRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(sourceSchema).build();
        Struct before = new Struct(recordSchema);
        Struct source = this.createSource(sourceSchema);
        before.put("id", (Object)1);
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = envelope.create((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    protected SourceRecord createUnknownRecord() {
        Schema recordSchema = SchemaBuilder.struct().name("unknown").field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    protected SourceRecord createUnknownUnnamedSchemaRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    protected String getSourceRecordHeaderByKey(SourceRecord record, String headerKey) {
        Iterator operationHeader = record.headers().allWithName(headerKey);
        if (!operationHeader.hasNext()) {
            return null;
        }
        Object value = ((Header)operationHeader.next()).value();
        return value != null ? value.toString() : null;
    }

    protected SourceRecord createUpdateRecordWithChangedFields() {
        Envelope changesEnvelope = Envelope.defineSchema().withName("changedFields.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).withSchema((Schema)SchemaBuilder.array((Schema)Schema.STRING_SCHEMA), new String[]{"changes"}).build();
        Struct before = new Struct(this.recordSchema);
        Struct after = new Struct(this.recordSchema);
        Struct source = this.createSource();
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        ArrayList<String> changes = new ArrayList<String>();
        changes.add("name");
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct struct = new Struct(changesEnvelope.schema());
        struct.put("op", (Object)Envelope.Operation.UPDATE.code());
        if (before != null) {
            struct.put("before", (Object)before);
        }
        struct.put("after", (Object)after);
        if (source != null) {
            struct.put("source", (Object)source);
        }
        if (Instant.now() != null) {
            struct.put("ts_ms", (Object)Instant.now().toEpochMilli());
        }
        struct.put("changes", changes);
        struct.put("transaction", (Object)transaction);
        SourceRecord updateRecord = new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)struct);
        return updateRecord;
    }

    protected SourceRecord addDropFieldsHeader(SourceRecord record, String name, List<String> values) {
        Schema dropFieldsSchema = SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA).optional().name(name).build();
        record.headers().add(name, values, dropFieldsSchema);
        return record;
    }

    protected SourceRecord createCreateRecordWithCreateTime(Instant creationTime) {
        Schema keySchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).build();
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        Struct key = new Struct(keySchema);
        Struct after = new Struct(recordSchema);
        Struct source = this.createSource();
        key.put("id", (Object)1);
        after.put("id", (Object)1);
        after.put("name", null);
        source.put("lsn", (Object)1234);
        Struct payload = envelope.create((Object)after, source, creationTime);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", keySchema, (Object)key, envelope.schema(), (Object)payload);
    }

    private Struct createSource() {
        return this.createSource(this.sourceSchema);
    }

    private Struct createSource(Schema sourceSchema) {
        Struct source = new Struct(sourceSchema);
        source.put("ts_ms", (Object)1588252618953L);
        source.put("ts_us", (Object)1588252618953000L);
        source.put("ts_ns", (Object)1588252618953000000L);
        return source;
    }
}

