/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.table;

import io.debezium.connector.SinkConnectorConfig;
import io.debezium.table.TableNamingStrategy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableNamingStrategy
implements TableNamingStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTableNamingStrategy.class);
    private final Pattern sourcePattern = Pattern.compile("\\$\\{(source\\.)(.*?)}");

    @Override
    public String resolveTableName(SinkConnectorConfig config, SinkRecord record) {
        String topicName = record.topic().replace(".", "_");
        String table = config.getTableNameFormat().replace("${topic}", topicName);
        table = this.resolveTableNameBySource(config, record, table);
        return table;
    }

    private String resolveTableNameBySource(SinkConnectorConfig config, SinkRecord record, String tableFormat) {
        String table = tableFormat;
        if (table.contains("${source.")) {
            if (this.isTombstone(record)) {
                LOGGER.warn("Ignore this record because it seems to be a tombstone that doesn't have source field, then cannot resolve table name in topic '{}', partition '{}', offset '{}'", new Object[]{record.topic(), record.kafkaPartition(), record.kafkaOffset()});
                return null;
            }
            try {
                Struct source = ((Struct)record.value()).getStruct("source");
                Matcher matcher = this.sourcePattern.matcher(table);
                while (matcher.find()) {
                    String target = matcher.group();
                    table = table.replace(target, source.getString(matcher.group(2)));
                }
            }
            catch (DataException e) {
                LOGGER.error("Failed to resolve table name with format '{}', check source field in topic '{}'", new Object[]{config.getTableNameFormat(), record.topic(), e});
                throw e;
            }
        }
        return table;
    }

    private boolean isTombstone(SinkRecord record) {
        return record.value() == null;
    }
}

