/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data.vector;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Vectors {
    private static final Logger LOGGER = LoggerFactory.getLogger(Vectors.class);

    static <T> List<T> fromVectorString(Schema schema, String value, Function<String, T> elementMapper) {
        Objects.requireNonNull(value, "value may not be null");
        value = value.trim();
        if (!value.startsWith("[") || !value.endsWith("]")) {
            LOGGER.warn("Cannot convert vector {}, expected format is [x,y,z,...]", (Object)value);
            return null;
        }
        value = value.substring(1, value.length() - 1);
        String[] strValues = value.split(",");
        ArrayList<T> result = new ArrayList<T>(strValues.length);
        for (String element : strValues) {
            result.add(elementMapper.apply(element.trim()));
        }
        return result;
    }
}

