/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metadata;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.debezium.util.Strings;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CollectionId {
    private final String namespace;
    private final String name;
    private final String realm;

    public CollectionId(String realm, String namespace, String name) {
        this.realm = "null".equalsIgnoreCase(realm) ? null : realm;
        this.namespace = "null".equalsIgnoreCase(namespace) ? null : namespace;
        this.name = "null".equalsIgnoreCase(name) ? null : name;
    }

    public CollectionId(String namespace, String name) {
        this(null, namespace, name);
    }

    public CollectionId(String name) {
        this(null, null, name);
    }

    @JsonGetter(value="identifier")
    public String identifier() {
        return this.toFullIdentiferString();
    }

    @JsonGetter(value="realm")
    public String realm() {
        return this.realm;
    }

    @JsonGetter(value="namespace")
    public String namespace() {
        return this.namespace;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String toString() {
        return "CollectionId{realm='" + this.realm + "', namespace='" + this.namespace + "', name='" + this.name + "'}";
    }

    @JsonIgnore
    public String toFullIdentiferString() {
        StringBuilder sb = new StringBuilder();
        if (null != this.realm && !"null".equals(this.realm)) {
            sb.append(this.realm).append(".");
        }
        if (null != this.namespace && !"null".equals(this.namespace)) {
            sb.append(this.namespace).append(".");
        }
        sb.append(this.name);
        return sb.toString();
    }

    public CollectionId toUpperCase() {
        return new CollectionId(Strings.isNullOrBlank(this.realm) ? this.realm : this.realm.toUpperCase(), Strings.isNullOrBlank(this.namespace) ? this.namespace : this.namespace.toUpperCase(), Strings.isNullOrBlank(this.name) ? this.name : this.name.toUpperCase());
    }

    public CollectionId toLowerCase() {
        return new CollectionId(Strings.isNullOrBlank(this.realm) ? this.realm : this.realm.toLowerCase(), Strings.isNullOrBlank(this.namespace) ? this.namespace : this.namespace.toLowerCase(), Strings.isNullOrBlank(this.name) ? this.name : this.name.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionId tableId = (CollectionId)o;
        return Objects.equals(this.realm, tableId.realm) && Objects.equals(this.namespace, tableId.namespace) && Objects.equals(this.name, tableId.name);
    }

    public int hashCode() {
        return Objects.hash(this.realm, this.namespace, this.name);
    }
}

