/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.DebeziumException;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import io.debezium.util.Clock;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.connect.data.Struct;

public class SchemaChangeEvent {
    private final String database;
    private final String schema;
    private final String ddl;
    private final Set<Table> tables;
    private final SchemaChangeEventType type;
    private final Map<String, ?> partition;
    private final Map<String, ?> offset;
    private final Struct source;
    private final boolean isFromSnapshot;
    private final Instant timestamp;
    private final TableChanges tableChanges = new TableChanges();

    private SchemaChangeEvent(Map<String, ?> partition, Map<String, ?> offset, Struct source, String database, String schema, String ddl, Table table, SchemaChangeEventType type, boolean isFromSnapshot, TableId previousTableId) {
        this(partition, offset, source, database, schema, ddl, table != null ? Collections.singleton(table) : Collections.emptySet(), type, isFromSnapshot, Clock.SYSTEM.currentTimeAsInstant(), previousTableId);
    }

    private SchemaChangeEvent(Map<String, ?> partition, Map<String, ?> offset, Struct source, String database, String schema, String ddl, Set<Table> tables, SchemaChangeEventType type, boolean isFromSnapshot, Instant timestamp, TableId previousTableId) {
        this.partition = Objects.requireNonNull(partition, "partition must not be null");
        this.offset = Objects.requireNonNull(offset, "offset must not be null");
        this.source = Objects.requireNonNull(source, "source must not be null");
        this.database = Objects.requireNonNull(database, "database must not be null");
        this.schema = schema;
        this.ddl = ddl;
        this.tables = Objects.requireNonNull(tables, "tables must not be null");
        this.type = Objects.requireNonNull(type, "type must not be null");
        this.isFromSnapshot = isFromSnapshot;
        this.timestamp = timestamp;
        switch (type.ordinal()) {
            case 0: {
                tables.forEach(this.tableChanges::create);
                break;
            }
            case 1: {
                if (previousTableId == null) {
                    tables.forEach(this.tableChanges::alter);
                    break;
                }
                tables.forEach(t -> this.tableChanges.rename((Table)t, previousTableId));
                break;
            }
            case 2: {
                tables.stream().map(Table::id).forEach(this.tableChanges::drop);
                break;
            }
        }
    }

    public Map<String, ?> getPartition() {
        return this.partition;
    }

    public Map<String, ?> getOffset() {
        return this.offset;
    }

    public Struct getSource() {
        return this.source;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDdl() {
        return this.ddl;
    }

    public Set<Table> getTables() {
        return this.tables;
    }

    public SchemaChangeEventType getType() {
        return this.type;
    }

    public boolean isFromSnapshot() {
        return this.isFromSnapshot;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public TableChanges getTableChanges() {
        return this.tableChanges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaChangeEvent that = (SchemaChangeEvent)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.schema, that.schema) && Objects.equals(this.ddl, that.ddl) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.database, this.schema, this.ddl, this.type});
    }

    public String toString() {
        return "SchemaChangeEvent [database=" + this.database + ", schema=" + this.schema + ", ddl=" + this.ddl + ", tables=" + String.valueOf(this.tables) + ", type=" + String.valueOf((Object)this.type) + ", ts_ms=" + this.timestamp.toEpochMilli() + "]";
    }

    public static SchemaChangeEvent of(SchemaChangeEventType type, Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table, boolean isFromSnapshot) {
        return new SchemaChangeEvent(partition.getSourcePartition(), offsetContext.getOffset(), offsetContext.getSourceInfo(), databaseName, schemaName, ddl, table, type, isFromSnapshot, null);
    }

    public static SchemaChangeEvent ofTableChange(TableChanges.TableChange change, Map<String, ?> partition, Map<String, ?> offset, Struct source, String databaseName, String schemaName) {
        return new SchemaChangeEvent(partition, offset, source, databaseName, schemaName, null, change.getTable(), SchemaChangeEvent.toSchemaChangeEventType(change.getType()), false, change.getPreviousId());
    }

    public static SchemaChangeEvent ofDatabase(Partition partition, OffsetContext offsetContext, String databaseName, String ddl, boolean isFromSnapshot) {
        return SchemaChangeEvent.of(SchemaChangeEventType.DATABASE, partition, offsetContext, databaseName, null, ddl, null, isFromSnapshot);
    }

    public static SchemaChangeEvent ofSnapshotCreate(Partition partition, OffsetContext offsetContext, String databaseName, Table table) {
        return SchemaChangeEvent.ofCreate(partition, offsetContext, databaseName, table.id().schema(), null, table, true);
    }

    public static SchemaChangeEvent ofCreate(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table, boolean isFromSnapshot) {
        return SchemaChangeEvent.of(SchemaChangeEventType.CREATE, partition, offsetContext, databaseName, schemaName, ddl, table, isFromSnapshot);
    }

    public static SchemaChangeEvent ofAlter(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table) {
        return SchemaChangeEvent.of(SchemaChangeEventType.ALTER, partition, offsetContext, databaseName, schemaName, ddl, table, false);
    }

    public static SchemaChangeEvent ofRename(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table, TableId previousTableId) {
        return new SchemaChangeEvent(partition.getSourcePartition(), offsetContext.getOffset(), offsetContext.getSourceInfo(), databaseName, schemaName, ddl, table, SchemaChangeEventType.ALTER, false, previousTableId);
    }

    public static SchemaChangeEvent ofDrop(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table) {
        return SchemaChangeEvent.of(SchemaChangeEventType.DROP, partition, offsetContext, databaseName, schemaName, ddl, table, false);
    }

    public static SchemaChangeEvent ofTruncate(Partition partition, OffsetContext offsetContext, String databaseName, String schemaName, String ddl, Table table) {
        return SchemaChangeEvent.of(SchemaChangeEventType.TRUNCATE, partition, offsetContext, databaseName, schemaName, ddl, table, false);
    }

    private static SchemaChangeEventType toSchemaChangeEventType(TableChanges.TableChangeType type) {
        switch (type) {
            case CREATE: {
                return SchemaChangeEventType.CREATE;
            }
            case ALTER: {
                return SchemaChangeEventType.ALTER;
            }
            case DROP: {
                return SchemaChangeEventType.DROP;
            }
        }
        throw new DebeziumException("Unknown table change event type " + String.valueOf((Object)type));
    }

    public static enum SchemaChangeEventType {
        CREATE,
        ALTER,
        DROP,
        TRUNCATE,
        DATABASE;

    }
}

