/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.sink;

import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.sink.filter.FieldFilterFactory;
import io.debezium.sink.naming.CollectionNamingStrategy;
import io.debezium.sink.naming.DefaultCollectionNamingStrategy;
import org.apache.kafka.common.config.ConfigDef;

public interface SinkConnectorConfig {
    public static final String COLLECTION_NAME_FORMAT = "collection.name.format";
    public static final String DEPRECATED_TABLE_NAME_FORMAT = "table.name.format";
    public static final Field COLLECTION_NAME_FORMAT_FIELD = Field.create((String)"collection.name.format").withDisplayName("A format string for the collection name").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)3)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("${topic}").withDescription("A format string for the table, which may contain '${topic}' as a placeholder for the original topic name.").withDeprecatedAliases(new String[]{"table.name.format"});
    public static final String COLLECTION_NAMING_STRATEGY = "collection.naming.strategy";
    public static final String DEPRECATED_TABLE_NAMING_STRATEGY = "table.naming.strategy";
    public static final Field COLLECTION_NAMING_STRATEGY_FIELD = Field.create((String)"collection.naming.strategy").withDisplayName("Name of the strategy class that implements the CollectionNamingStrategy interface").withType(ConfigDef.Type.CLASS).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault(DefaultCollectionNamingStrategy.class.getName()).withDescription("Name of the strategy class that implements the CollectionNamingStrategy interface.").withDeprecatedAliases(new String[]{"table.naming.strategy"});
    public static final String FIELD_INCLUDE_LIST = "field.include.list";
    public static final Field FIELD_INCLUDE_LIST_FIELD = Field.create((String)"field.include.list").withDisplayName("Include Fields").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("A comma-separated list of regular expressions matching fully-qualified names of fields that should be included in change events. The field names must be delimited by the format <topic>:<field> ");
    public static final String FIELD_EXCLUDE_LIST = "field.exclude.list";
    public static final Field FIELD_EXCLUDE_LIST_FIELD = Field.create((String)"field.exclude.list").withDisplayName("Exclude Fields").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("A comma-separated list of regular expressions matching fully-qualified names of fields that should be excluded from change events. The field names must be delimited by the format <topic>:<field> ");
    public static final String TRUNCATE_ENABLED = "truncate.enabled";
    public static final Field TRUNCATE_ENABLED_FIELD = Field.create((String)"truncate.enabled").withDisplayName("Controls whether tables can be truncated by the connector").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Whether to process debezium event `t` as truncate statement.");
    public static final String DELETE_ENABLED = "delete.enabled";
    public static final Field DELETE_ENABLED_FIELD = Field.create((String)"delete.enabled").withDisplayName("Controls whether records can be deleted by the connector").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Whether to treat `null` record values as deletes. Requires primary.key.mode to be `record.key`.");
    public static final String PRIMARY_KEY_MODE = "primary.key.mode";
    public static final Field PRIMARY_KEY_MODE_FIELD = Field.create((String)"primary.key.mode").withDisplayName("The primary key mode").withEnum(PrimaryKeyMode.class, (Enum)PrimaryKeyMode.NONE).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("The primary key mode");
    public static final String DEFAULT_TIME_ZONE = "UTC";
    public static final String USE_TIME_ZONE = "use.time.zone";
    public static final String DEPRECATED_DATABASE_TIME_ZONE = "database.time_zone";
    public static final Field USE_TIME_ZONE_FIELD = Field.create((String)"use.time.zone").withDisplayName("The timezone used when inserting temporal values.").withDefault("UTC").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The timezone used when inserting temporal values. Defaults to UTC.").withDeprecatedAliases(new String[]{"database.time_zone"});
    public static final String BATCH_SIZE = "batch.size";
    public static final Field BATCH_SIZE_FIELD = Field.create((String)"batch.size").withDisplayName("Specifies how many records to attempt to batch together into the destination table, when possible. You can also configure the connector\u2019s underlying consumer\u2019s max.poll.records using consumer.override.max.poll.records in the connector configuration.").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(500).withDescription("Specifies how many records to attempt to batch together into the destination table, when possible. You can also configure the connector\u2019s underlying consumer\u2019s max.poll.records using consumer.override.max.poll.records in the connector configuration.");

    public String getCollectionNameFormat();

    public PrimaryKeyMode getPrimaryKeyMode();

    public boolean isTruncateEnabled();

    public boolean isDeleteEnabled();

    public String useTimeZone();

    public int getBatchSize();

    public CollectionNamingStrategy getCollectionNamingStrategy();

    public FieldFilterFactory.FieldNameFilter getFieldFilter();

    public static enum PrimaryKeyMode implements EnumeratedValue
    {
        NONE("none"),
        KAFKA("kafka"),
        RECORD_KEY("record_key"),
        RECORD_VALUE("record_value"),
        RECORD_HEADER("record_header");

        private final String mode;

        private PrimaryKeyMode(String mode) {
            this.mode = mode;
        }

        public static PrimaryKeyMode parse(String value) {
            for (PrimaryKeyMode option : PrimaryKeyMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return RECORD_KEY;
        }

        public String getValue() {
            return this.mode;
        }
    }
}

