/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.utils.Labels;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;

@Description(value="Add a route to the list.")
public class AddRouteDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    public static final String KIND_ROUTE = "Route";
    private final OpenshiftConfig config;

    public AddRouteDecorator(OpenshiftConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        if (!this.config.getRoute().isExpose()) {
            return;
        }
        if (this.contains(list, "route.openshift.io/v1", KIND_ROUTE, this.config.getName())) {
            return;
        }
        list.addToItems(new HasMetadata[]{((RouteBuilder)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(this.config.getName())).withLabels(Labels.createLabelsAsMap((BaseConfig)this.config, (String)KIND_ROUTE))).endMetadata()).withNewSpec().endSpec()).build()});
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddServiceResourceDecorator.class};
    }
}

