/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import io.dropwizard.client.ssl.TlsConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class DropwizardSSLConnectionSocketFactory {
    private final TlsConfiguration configuration;

    public DropwizardSSLConnectionSocketFactory(TlsConfiguration configuration) {
        this.configuration = configuration;
    }

    public SSLConnectionSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory(this.buildSslContext(), this.getSupportedProtocols(), this.getSupportedCiphers(), this.chooseHostnameVerifier());
    }

    private String[] getSupportedCiphers() {
        List<String> supportedCiphers = this.configuration.getSupportedCiphers();
        if (supportedCiphers == null) {
            return null;
        }
        return supportedCiphers.toArray(new String[supportedCiphers.size()]);
    }

    private String[] getSupportedProtocols() {
        List<String> supportedProtocols = this.configuration.getSupportedProtocols();
        if (supportedProtocols == null) {
            return null;
        }
        return supportedProtocols.toArray(new String[supportedProtocols.size()]);
    }

    private HostnameVerifier chooseHostnameVerifier() {
        HostnameVerifier hostnameVerifier = this.configuration.isVerifyHostname() ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : new NoopHostnameVerifier();
        return hostnameVerifier;
    }

    private SSLContext buildSslContext() throws SSLInitializationException {
        SSLContext sslContext;
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.useProtocol(this.configuration.getProtocol());
            this.loadKeyMaterial(sslContextBuilder);
            this.loadTrustMaterial(sslContextBuilder);
            sslContext = sslContextBuilder.build();
        }
        catch (Exception e) {
            throw new SSLInitializationException(e.getMessage(), (Throwable)e);
        }
        return sslContext;
    }

    private void loadKeyMaterial(SSLContextBuilder sslContextBuilder) throws Exception {
        if (this.configuration.getKeyStorePath() != null) {
            KeyStore keystore = this.loadKeyStore(this.configuration.getKeyStoreType(), this.configuration.getKeyStorePath(), this.configuration.getKeyStorePassword());
            sslContextBuilder.loadKeyMaterial(keystore, this.configuration.getKeyStorePassword().toCharArray());
        }
    }

    private void loadTrustMaterial(SSLContextBuilder sslContextBuilder) throws Exception {
        KeyStore trustStore = null;
        if (this.configuration.getTrustStorePath() != null) {
            trustStore = this.loadKeyStore(this.configuration.getTrustStoreType(), this.configuration.getTrustStorePath(), this.configuration.getTrustStorePassword());
        }
        TrustSelfSignedStrategy trustStrategy = null;
        if (this.configuration.isTrustSelfSignedCertificates()) {
            trustStrategy = new TrustSelfSignedStrategy();
        }
        sslContextBuilder.loadTrustMaterial(trustStore, (TrustStrategy)trustStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String type, File path, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(type);
        try (FileInputStream inputStream = new FileInputStream(path);){
            keyStore.load(inputStream, password.toCharArray());
        }
        return keyStore;
    }
}

