/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client.proxy;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthConfiguration {
    public static final String BASIC_AUTH_SCHEME = "Basic";
    public static final String NTLM_AUTH_SCHEME = "NTLM";
    public static final String USERNAME_PASSWORD_CREDS = "UsernamePassword";
    public static final String NT_CREDS = "NT";
    @NotEmpty
    private String username = "";
    @NotEmpty
    private String password = "";
    @Pattern(regexp="Basic|NTLM")
    private @Pattern(regexp="Basic|NTLM") @Nullable String authScheme;
    private @Nullable String realm;
    private @Nullable String hostname;
    private @Nullable String domain;
    @Pattern(regexp="UsernamePassword|NT", flags={Pattern.Flag.CASE_INSENSITIVE})
    private @Pattern(regexp="UsernamePassword|NT", flags={Pattern.Flag.CASE_INSENSITIVE}) @Nullable String credentialType;

    public AuthConfiguration() {
    }

    public AuthConfiguration(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public AuthConfiguration(String username, String password, String authScheme, String realm, String hostname, String domain, String credentialType) {
        this.username = username;
        this.password = password;
        this.authScheme = authScheme;
        this.realm = realm;
        this.hostname = hostname;
        this.domain = domain;
        this.credentialType = credentialType;
    }

    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @JsonProperty
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty
    public String getPassword() {
        return this.password;
    }

    @JsonProperty
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty
    public @Nullable String getAuthScheme() {
        return this.authScheme;
    }

    @JsonProperty
    public void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }

    @JsonProperty
    public @Nullable String getRealm() {
        return this.realm;
    }

    @JsonProperty
    public void setRealm(String realm) {
        this.realm = realm;
    }

    @JsonProperty
    public @Nullable String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @JsonProperty
    public @Nullable String getDomain() {
        return this.domain;
    }

    @JsonProperty
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty
    public @Nullable String getCredentialType() {
        return this.credentialType;
    }

    @JsonProperty
    public void setCredentialType(String credentialType) {
        this.credentialType = credentialType;
    }
}

