/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.params;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.ParamConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class AbstractParamConverter<T>
implements ParamConverter<T> {
    private final Constructor<T> constructor;
    private final String parameterName;
    private final @Nullable String defaultValue;

    public AbstractParamConverter(Constructor<T> constructor, String parameterName, @Nullable String defaultValue) {
        this.constructor = constructor;
        this.parameterName = parameterName;
        this.defaultValue = defaultValue;
    }

    public @Nullable T fromString(String value) {
        try {
            String defaultedValue = (value == null || value.isEmpty()) && this.defaultValue != null ? this.defaultValue : value;
            return this.constructor.newInstance(defaultedValue, this.parameterName);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            throw new ExtractorException(cause);
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
    }

    public String toString(T value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL((Object)"value"));
        }
        return value.toString();
    }
}

