/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging.filter;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.common.filter.FilterFactory;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Set;

@JsonTypeName(value="uri")
public class UriFilterFactory
implements FilterFactory<IAccessEvent> {
    @NotNull
    private Set<String> uris = Collections.emptySet();

    @JsonProperty
    public Set<String> getUris() {
        return this.uris;
    }

    @JsonProperty
    public void setUris(Set<String> uris) {
        this.uris = uris;
    }

    public Filter<IAccessEvent> build() {
        return new Filter<IAccessEvent>(){

            public FilterReply decide(IAccessEvent event) {
                if (UriFilterFactory.this.uris.contains(event.getRequestURI())) {
                    return FilterReply.DENY;
                }
                return FilterReply.NEUTRAL;
            }
        };
    }
}

