/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Strings {
    public static boolean notEmpty(String text) {
        return text != null && text.length() > 0;
    }

    public static String nullIfEmpty(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public static String emptyIfNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        return Strings.notEmpty(value) ? value : defaultValue;
    }

    public static List<String> splitAsList(String text, String delimiter) {
        ArrayList<String> answer = new ArrayList<String>();
        if (text != null && text.length() > 0) {
            answer.addAll(Arrays.asList(text.split(delimiter)));
        }
        return answer;
    }

    public static List<String> splitAndTrimAsList(String text, String sep) {
        ArrayList<String> answer = new ArrayList<String>();
        if (text != null && text.length() > 0) {
            for (String v : text.split(sep)) {
                String trim = v.trim();
                if (trim.length() <= 0) continue;
                answer.add(trim);
            }
        }
        return answer;
    }

    public static String join(Collection<?> collection, String separator) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object next : collection) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(next);
        }
        return buffer.toString();
    }

    public static String join(String separator, Object ... objects) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(object);
        }
        return buffer.toString();
    }

    public static String joinNotNull(String separator, Object ... objects) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object object : objects) {
            if (object == null) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(object);
        }
        return buffer.toString();
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object).toString();
        }
        return object.toString();
    }

    public static String unquote(String text) {
        if (text != null && text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String rpad(String delimiter, String str, int max) {
        for (int i = 1; i <= max; ++i) {
            str = str.concat(delimiter);
        }
        return str;
    }

    public static String rpadByMaxSize(String delimiter, String str, int max) {
        int len = max - str.length();
        for (int i = 1; i <= len; ++i) {
            str = str.concat(delimiter);
        }
        return str;
    }

    public static boolean isNullOrBlank(String value) {
        return value == null || value.length() == 0 || value.trim().length() == 0;
    }

    public static boolean isNotBlank(String text) {
        return !Strings.isNullOrBlank(text);
    }

    public static List<String> parseDelimitedString(String value, String delim) {
        return Strings.parseDelimitedString(value, delim, true);
    }

    public static List<String> parseDelimitedString(String value, String delim, boolean trim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        boolean isEscaped = false;
        for (int i = 0; i < value.length(); ++i) {
            boolean isDelimiter;
            char c = value.charAt(i);
            boolean bl = isDelimiter = delim.indexOf(c) >= 0;
            if (!isEscaped && c == '\\') {
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                sb.append(c);
            } else if (isDelimiter && (expecting & DELIMITER) > 0) {
                if (trim) {
                    list.add(sb.toString().trim());
                } else {
                    list.add(sb.toString());
                }
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
            } else if (c == '\"' && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
            } else if (c == '\"' && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
            } else if ((expecting & CHAR) > 0) {
                sb.append(c);
            } else {
                throw new IllegalArgumentException("Invalid delimited string: " + value);
            }
            isEscaped = false;
        }
        if (sb.length() > 0) {
            if (trim) {
                list.add(sb.toString().trim());
            } else {
                list.add(sb.toString());
            }
        }
        return list;
    }
}

