/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import java.util.List;
import java.util.Map;

public class ProfileDTO {
    private String id;
    private String version;
    private String profileHash;
    private List<String> parents;
    private boolean overlay;
    private boolean abstractProfile;
    private boolean locked;
    private boolean hidden;
    private Map<String, String> attributes;
    private List<String> configurations;
    private List<String> associatedContainers;
    private List<String> bundles;
    private List<String> fabs;
    private List<String> features;
    private List<String> repositories;
    private List<String> overrides;
    private String overlayLink;
    private String requirementsLink;
    private String fileNameLinks;

    public ProfileDTO() {
    }

    public ProfileDTO(Profile profile) {
        this.id = profile.getId();
        this.version = profile.getVersion();
        this.profileHash = profile.getProfileHash();
        this.parents = Profiles.profileIds((Profile[])profile.getParents());
        this.overlay = profile.isOverlay();
        this.abstractProfile = profile.isAbstract();
        this.locked = profile.isLocked();
        this.hidden = profile.isHidden();
        this.attributes = profile.getAttributes();
        this.bundles = profile.getBundles();
        this.features = profile.getFeatures();
        this.repositories = profile.getRepositories();
        this.fabs = profile.getFabs();
        this.overrides = profile.getOverrides();
        this.associatedContainers = Containers.containerIds((Container[])profile.getAssociatedContainers());
        this.configurations = profile.getConfigurationFileNames();
    }

    public ProfileDTO(Profile profile, String overlayLink, String requirementsLink, String fileNameLinks) {
        this(profile);
        this.overlayLink = overlayLink;
        this.requirementsLink = requirementsLink;
        this.fileNameLinks = fileNameLinks;
    }

    public String toString() {
        return "ProfileDTO{id='" + this.id + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProfileHash() {
        return this.profileHash;
    }

    public void setProfileHash(String profileHash) {
        this.profileHash = profileHash;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public boolean isAbstractProfile() {
        return this.abstractProfile;
    }

    public void setAbstractProfile(boolean abstractProfile) {
        this.abstractProfile = abstractProfile;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public List<String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<String> configurations) {
        this.configurations = configurations;
    }

    public List<String> getAssociatedContainers() {
        return this.associatedContainers;
    }

    public void setAssociatedContainers(List<String> associatedContainers) {
        this.associatedContainers = associatedContainers;
    }

    public List<String> getBundles() {
        return this.bundles;
    }

    public void setBundles(List<String> bundles) {
        this.bundles = bundles;
    }

    public List<String> getFabs() {
        return this.fabs;
    }

    public void setFabs(List<String> fabs) {
        this.fabs = fabs;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public List<String> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(List<String> overrides) {
        this.overrides = overrides;
    }

    public String getOverlayLink() {
        return this.overlayLink;
    }

    public void setOverlayLink(String overlayLink) {
        this.overlayLink = overlayLink;
    }

    public String getRequirementsLink() {
        return this.requirementsLink;
    }

    public void setRequirementsLink(String requirementsLink) {
        this.requirementsLink = requirementsLink;
    }

    public String getFileNameLinks() {
        return this.fileNameLinks;
    }

    public void setFileNameLinks(String fileNameLinks) {
        this.fileNameLinks = fileNameLinks;
    }
}

