/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedAvlNode<T> {
    T key;
    LinkedAvlNode<T> left;
    LinkedAvlNode<T> right;
    LinkedAvlNode<T> next;
    LinkedAvlNode<T> previous;
    transient int depth;
    transient int index;
    boolean isLeft;
    transient int height = 1;

    public LinkedAvlNode(T theKey) {
        this.key = theKey;
        this.left = null;
        this.right = null;
    }

    public void setLeft(LinkedAvlNode<T> left) {
        this.left = left;
    }

    public void setRight(LinkedAvlNode<T> right) {
        this.right = right;
    }

    public LinkedAvlNode<T> getNext() {
        return this.next;
    }

    public LinkedAvlNode<T> getPrevious() {
        return this.previous;
    }

    public LinkedAvlNode<T> getLeft() {
        return this.left;
    }

    public LinkedAvlNode<T> getRight() {
        return this.right;
    }

    public T getKey() {
        return this.key;
    }

    public boolean isLeaf() {
        return this.right == null && this.left == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getHeight() {
        return this.height;
    }

    public void setNext(LinkedAvlNode<T> next) {
        this.next = next;
    }

    public void setPrevious(LinkedAvlNode<T> previous) {
        this.previous = previous;
    }

    public int computeHeight() {
        int rh;
        int lh;
        if (this.right == null && this.left == null) {
            this.height = 1;
            return this.height;
        }
        if (this.isLeft) {
            lh = this.left == null ? -1 : this.left.computeHeight();
            rh = this.right == null ? -1 : this.right.getHeight();
        } else {
            rh = this.right == null ? -1 : this.right.computeHeight();
            lh = this.left == null ? -1 : this.left.getHeight();
        }
        this.height = 1 + Math.max(lh, rh);
        return this.height;
    }

    public int getBalance() {
        int lh = this.left == null ? 0 : this.left.computeHeight();
        int rh = this.right == null ? 0 : this.right.computeHeight();
        return rh - lh;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        return "[" + this.key + "]";
    }
}

