/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncoderFactory;
import org.apache.directory.server.kerberos.shared.io.encoder.HostAddressesEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPart;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncKrbPrivPartEncoder
implements Encoder,
EncoderFactory {
    private static final int APPLICATION_CODE = 28;

    public Encoder getEncoder() {
        return new EncKrbPrivPartEncoder();
    }

    public byte[] encode(Encodable privPart) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        DERSequence privPartSequence = this.encodePrivatePartSequence((EncKrbPrivPart)privPart);
        aos.writeObject(DERApplicationSpecific.valueOf(28, privPartSequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodePrivatePartSequence(EncKrbPrivPart message) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, new DEROctetString(message.getUserData())));
        if (message.getTimestamp() != null) {
            sequence.add(new DERTaggedObject(1, KerberosTimeEncoder.encode(message.getTimestamp())));
        }
        if (message.getMicroSecond() != null) {
            sequence.add(new DERTaggedObject(2, DERInteger.valueOf(message.getMicroSecond())));
        }
        if (message.getSequenceNumber() != null) {
            sequence.add(new DERTaggedObject(3, DERInteger.valueOf(message.getSequenceNumber())));
        }
        sequence.add(new DERTaggedObject(4, HostAddressesEncoder.encode(message.getSenderAddress())));
        if (message.getRecipientAddress() != null) {
            sequence.add(new DERTaggedObject(5, HostAddressesEncoder.encode(message.getRecipientAddress())));
        }
        return sequence;
    }
}

