/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue.SyncRequestValueControlDecoder;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationModeEnum;
import org.apache.directory.shared.ldap.util.StringTools;

public class SyncRequestValueControl
extends AbstractControl {
    public static final String CONTROL_OID = "1.3.6.1.4.1.4203.1.9.1.1";
    private SynchronizationModeEnum mode;
    private byte[] cookie;
    private boolean reloadHint;
    private int syncRequestValueLength;

    public SyncRequestValueControl() {
        super(CONTROL_OID);
        this.decoder = new SyncRequestValueControlDecoder();
    }

    public SynchronizationModeEnum getMode() {
        return this.mode;
    }

    public void setMode(SynchronizationModeEnum mode) {
        this.mode = mode;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public boolean isReloadHint() {
        return this.reloadHint;
    }

    public void setReloadHint(boolean reloadHint) {
        this.reloadHint = reloadHint;
    }

    public int computeLength() {
        this.syncRequestValueLength = 3;
        if (this.cookie != null) {
            this.syncRequestValueLength += 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length;
        }
        if (this.reloadHint) {
            this.syncRequestValueLength += 3;
        }
        this.valueLength = 1 + TLV.getNbBytes(this.syncRequestValueLength) + this.syncRequestValueLength;
        return super.computeLength(this.valueLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err("ERR_04023", new Object[0]));
        }
        super.encode(buffer);
        buffer.put((byte)4);
        buffer.put(TLV.getBytes(this.valueLength));
        buffer.put((byte)48);
        buffer.put(TLV.getBytes(this.syncRequestValueLength));
        buffer.put((byte)10);
        buffer.put((byte)1);
        buffer.put(Value.getBytes(this.mode.getValue()));
        if (this.cookie != null) {
            Value.encode(buffer, this.cookie);
        }
        if (this.reloadHint) {
            Value.encode(buffer, this.reloadHint);
        }
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put((byte)48);
                buffer.put(TLV.getBytes(this.syncRequestValueLength));
                buffer.put((byte)10);
                buffer.put((byte)1);
                buffer.put(Value.getBytes(this.mode.getValue()));
                if (this.cookie != null) {
                    Value.encode(buffer, this.cookie);
                }
                if (this.reloadHint) {
                    Value.encode(buffer, this.reloadHint);
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncRequestValue control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        mode              : '").append((Object)this.mode).append("'\n");
        sb.append("        cookie            : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
        sb.append("        refreshAndPersist : '").append(this.reloadHint).append("'\n");
        return sb.toString();
    }
}

