/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitStringSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(BitStringSyntaxChecker.class);
    private static final long serialVersionUID = 1L;

    public BitStringSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.6");
    }

    public static boolean isValid(String strValue) {
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        int pos = 0;
        if (!StringTools.isCharASCII(strValue, pos++, '\'')) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        if (!StringTools.isBit(strValue, pos++)) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        while (StringTools.isBit(strValue, pos)) {
            ++pos;
        }
        if (!StringTools.isCharASCII(strValue, pos++, '\'')) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        if (!StringTools.isCharASCII(strValue, pos, 'B')) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        LOG.debug("Syntax valid for '{}'", (Object)strValue);
        return true;
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", strValue);
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        return BitStringSyntaxChecker.isValid(strValue);
    }
}

