/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest;

import io.fabric8.api.Container;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.jmx.ContainerDTO;
import io.fabric8.common.util.Strings;
import io.fabric8.rest.ProfileResource;
import io.fabric8.rest.ResourceSupport;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class ContainerResource
extends ResourceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerResource.class);
    private final Container container;

    public ContainerResource(ResourceSupport parent, Container container) {
        super(parent);
        this.container = container;
    }

    @GET
    public ContainerDTO details() {
        return new ContainerDTO(this.container, this.getParentBaseUri());
    }

    @GET
    @Path(value="profiles")
    public Map<String, String> profiles() {
        if (this.container != null) {
            List profileIds = Profiles.profileIds((Profile[])this.container.getProfiles());
            return this.mapToLinks(profileIds, "profile/");
        }
        return Collections.EMPTY_MAP;
    }

    @Path(value="profile/{profileId}")
    public ProfileResource version(@PathParam(value="profileId") String profileId) {
        Profile profile;
        if (Strings.isNotBlank((String)profileId) && this.container != null && (profile = Profiles.profile((Profile[])this.container.getProfiles(), (String)profileId)) != null) {
            return new ProfileResource((ResourceSupport)this, profile);
        }
        return null;
    }
}

