/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.rest;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.jmx.VersionDTO;
import io.fabric8.common.util.Strings;
import io.fabric8.rest.FabricResource;
import io.fabric8.rest.ProfileResource;
import io.fabric8.rest.ResourceSupport;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class VersionResource
extends ResourceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FabricResource.class);
    private final FabricResource fabricResource;
    private final Version version;

    public VersionResource(FabricResource fabricResource, Version version) {
        super(fabricResource, "/version/" + version.toString() + "/");
        this.fabricResource = fabricResource;
        this.version = version;
    }

    public String toString() {
        return "VersionResource{version=" + this.version + '}';
    }

    @GET
    public VersionDTO details() {
        return new VersionDTO(this.getLink("profiles"));
    }

    @GET
    @Path(value="profiles")
    public Map<String, String> profiles() {
        if (this.version != null) {
            List profileIds = Profiles.profileIds((Profile[])this.version.getProfiles());
            return this.mapToLinks(profileIds, "profile/");
        }
        return Collections.EMPTY_MAP;
    }

    @Path(value="profile/{profileId}")
    public ProfileResource version(@PathParam(value="profileId") String profileId) {
        Profile profile;
        if (Strings.isNotBlank((String)profileId) && this.version != null && this.version.hasProfile(profileId) && (profile = this.version.getProfile(profileId)) != null) {
            return new ProfileResource((ResourceSupport)this, profile);
        }
        return null;
    }

    @Override
    public FabricService getFabricService() {
        return this.fabricResource.getFabricService();
    }

    public FabricResource getFabricResource() {
        return this.fabricResource;
    }
}

